package com.blogspot.berndschiffer.fluessigererbauer;

public class ErzeugeAbschnitte {

  private final Abschnitte abschnitte = new Abschnitte();

  public static AbschnitteWertZuStelleDescriptor<ErzeugeAbschnitte> mitNamen(
      final String name) {
    final ErzeugeAbschnitte erzeugeAbschnitte = new ErzeugeAbschnitte();
    return mitName(name, erzeugeAbschnitte);
  }

  private static AbschnitteWertZuStelleDescriptor<ErzeugeAbschnitte> mitName(
      final String name, final ErzeugeAbschnitte erzeugeAbschnitte) {
    final Abschnitt abschnitt = new Abschnitt();
    abschnitt.setName(name);
    erzeugeAbschnitte.abschnitte.add(abschnitt);
    return new AbschnitteWertZuStelleDescriptor<ErzeugeAbschnitte>(
        erzeugeAbschnitte, new WertZuStelleAddierer<ErzeugeAbschnitte>() {

          public ErzeugeAbschnitte addWertZuStelle(String wert, int stelle) {
            abschnitt.put(stelle, wert);
            return erzeugeAbschnitte;
          }
        });
  }

  public Abschnitte jetzt() {
    return abschnitte;
  }

  public AbschnitteWertZuStelleDescriptor<ErzeugeAbschnitte> undMitNamen(
      String name) {
    return mitName(name, this);
  }
}
