/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.ant.table;

import com.canoo.ant.filter.AllEqualsFilter;
import com.canoo.ant.filter.AllFilter;
import com.canoo.ant.filter.ITableFilter;
import com.canoo.ant.table.IPropertyTable;
import com.canoo.ant.table.TableFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class APropertyTable
implements IPropertyTable {
    private static final Logger LOG = Logger.getLogger((Class)APropertyTable.class);
    private static final int MAX_DEPTH = 10;
    private static final ThreadLocal DEPTH = new ThreadLocal();
    private File fContainer;
    private String fTable;
    private String fPrefix;
    private ITableFilter fFilter = new AllFilter();
    private List fRawTable;
    private List fMetaTable;
    protected static final String EMPTY = "";
    protected static final String KEY_JOIN = "JOIN";

    protected APropertyTable() {
    }

    private static void setDepth(int depth) {
        DEPTH.set(new Integer(depth));
    }

    private static int getDepth() {
        return (Integer)DEPTH.get();
    }

    public Map getColumnInfo() {
        List meta = this.getMetaTable();
        HashMap<String, IPropertyTable> result = new HashMap<String, IPropertyTable>(meta.size());
        List tableSpecificColumnInfo = new AllEqualsFilter("table").filter(meta, this.getTable());
        Iterator eachColumnInfo = tableSpecificColumnInfo.iterator();
        while (eachColumnInfo.hasNext()) {
            Properties colInfo = (Properties)eachColumnInfo.next();
            try {
                File container;
                IPropertyTable table = TableFactory.createTable(colInfo, this.getClass().getName());
                ITableFilter filter = TableFactory.createFilter(colInfo);
                if (colInfo.getProperty("container") != null) {
                    container = new File(this.getContainer().getParentFile(), colInfo.getProperty("container"));
                    colInfo.remove("container");
                } else {
                    container = this.getContainer();
                }
                String key = colInfo.getProperty("name");
                TableFactory.initOrDefault(table, filter, colInfo, container, key);
                result.put(key, table);
            }
            catch (Exception e) {
                LOG.error((Object)("cannot work with Property: " + colInfo.toString()), (Throwable)e);
            }
        }
        return result;
    }

    public List getPropertiesList(String filterValue, String prefix) {
        List result = this.getFilter().filter(this.getRawTable(), filterValue);
        if (APropertyTable.getDepth() > 10) {
            LOG.error((Object)("processing grounded due to excessive recursion calls: " + APropertyTable.getDepth()));
            return result;
        }
        APropertyTable.setDepth(APropertyTable.getDepth() + 1);
        Map colInfo = this.getColumnInfo();
        Iterator eachExpandable = colInfo.keySet().iterator();
        while (eachExpandable.hasNext()) {
            String expansionName = (String)eachExpandable.next();
            this.expandName(result, expansionName, colInfo);
        }
        APropertyTable.setDepth(APropertyTable.getDepth() - 1);
        result = this.getFilter().filter(result, filterValue);
        if (prefix != null && prefix.length() > 0) {
            result = this.mapPrefix(result, prefix);
        }
        return result;
    }

    private List mapPrefix(List result, String prefix) {
        ArrayList<Properties> collect = new ArrayList<Properties>(result.size());
        Iterator eachProps = result.iterator();
        while (eachProps.hasNext()) {
            Properties props = (Properties)eachProps.next();
            Properties mapped = new Properties();
            Iterator<Object> eachKey = props.keySet().iterator();
            while (eachKey.hasNext()) {
                String key = (String)eachKey.next();
                String value = props.getProperty(key);
                mapped.setProperty(prefix + "." + key, value);
            }
            collect.add(mapped);
        }
        return collect;
    }

    protected void expandName(List result, String expansionName, Map colInfo) {
        LinkedList expansions = new LinkedList();
        Iterator eachProperties = result.iterator();
        while (eachProperties.hasNext()) {
            Properties props = (Properties)eachProperties.next();
            List newExpansions = this.expandProps(props, expansionName, colInfo);
            if (newExpansions.size() <= 0) continue;
            eachProperties.remove();
            expansions.addAll(newExpansions);
        }
        result.addAll(expansions);
    }

    protected List expandProps(Properties props, String expansionName, Map colInfo) {
        String value = props.getProperty(expansionName);
        LinkedList<Properties> propExpansions = new LinkedList<Properties>();
        IPropertyTable expansionTable = (IPropertyTable)colInfo.get(expansionName);
        List expandWith = expansionTable.getPropertiesList(value, expansionTable.getPrefix());
        Iterator eachExpansion = expandWith.iterator();
        while (eachExpansion.hasNext()) {
            Properties expandProps = (Properties)eachExpansion.next();
            expandProps.putAll((Map<?, ?>)props);
            propExpansions.add(expandProps);
        }
        return propExpansions;
    }

    public File getContainer() {
        return this.fContainer;
    }

    public void setContainer(File container) {
        this.fContainer = container;
    }

    public String getTable() {
        return this.fTable;
    }

    public void setTable(String table) {
        this.fTable = table;
    }

    public ITableFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ITableFilter filter) {
        this.fFilter = filter;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
    }

    public List getRawTable() {
        this.fRawTable = this.getCachedTable(this.getTable(), this.fRawTable);
        return this.fRawTable;
    }

    public List getMetaTable() {
        this.fMetaTable = this.hasJoinTable() ? this.getCachedTable(KEY_JOIN, this.fMetaTable) : Collections.EMPTY_LIST;
        return this.fMetaTable;
    }

    protected boolean hasJoinTable() {
        return true;
    }

    protected List getCachedTable(String table, List tableCache) {
        if (tableCache != null) {
            return tableCache;
        }
        try {
            tableCache = this.read(table);
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot read " + this.getContainer() + " " + table), (Throwable)e);
            String message = "Cannot read container >" + this.getContainer() + "<";
            if (table != null) {
                message = message + " (table " + table + ")";
            }
            message = message + ": " + e.getMessage();
            throw new RuntimeException(message, e);
        }
        if (tableCache.isEmpty()) {
            LOG.debug((Object)("no entry in " + this.getContainer() + "/" + table));
        }
        LOG.debug((Object)(tableCache.size() + " entries in " + this.getContainer() + " " + table));
        return tableCache;
    }

    protected abstract List read(String var1) throws IOException;

    static {
        APropertyTable.setDepth(0);
    }
}

