/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import java.net.URL;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.log4j.Logger;

public final class HttpClientBoundary {
    private static final Logger LOG = Logger.getLogger((Class)HttpClientBoundary.class);
    private static final Cookie[] EMPTY_COOKIE_JAR = new Cookie[0];

    private HttpClientBoundary() {
    }

    public static Cookie[] getCookiesFromState(HttpState stateForUrl, URL url) {
        if (null == stateForUrl) {
            LOG.error((Object)("BUG in httpclient: Null state for " + url.toExternalForm()));
            return EMPTY_COOKIE_JAR;
        }
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        return CookiePolicy.getDefaultSpec().match(url.getHost(), port, url.getPath(), secure, stateForUrl.getCookies());
    }
}

