/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.Header;
import com.canoo.webtest.engine.Option;
import com.canoo.webtest.interfaces.IPropertyHandler;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PdfBoxPDFPage;
import com.canoo.webtest.steps.HtmlParserMessage;
import com.canoo.webtest.util.Checker;
import com.canoo.webtest.util.MapUtil;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DefaultPageCreator;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Configuration
extends Task {
    private static final Logger LOG = Logger.getLogger((Class)Configuration.class);
    public static final int PORT_HTTP = 80;
    public static final int PORT_HTTPS = 443;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_HOST = "localhost";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_FILE = "file";
    private static final String URL_SEPARATOR = "/";
    protected static final int DEFAULT_TIMEOUT = 300;
    private boolean fSummary;
    private int fPort = 80;
    private int fTimeout = 300;
    private String fProtocol = "http";
    private boolean fSaveResponse;
    private boolean fEasyAjax = false;
    private String fSavePrefix = "response";
    private String fAutoRefresh = "false";
    private String fResultFile = "WebTestReport.xml";
    private boolean fShowHtmlParserOutput;
    private boolean fHaltOnError;
    private boolean fHaltOnFailure;
    private String fErrorProperty;
    private String fFailureProperty;
    private String fDefaultPropertyType;
    private File fSummaryFile;
    private String fHost = "localhost";
    private String fBasePath;
    private File fResultPath;
    private File fWebtestResultDir;
    private IPropertyHandler fPropertyHandler;
    private final List fHeaderList = new LinkedList();
    private final List fOptionList = new LinkedList();
    private Context fContext;
    private int resultFolderIndex = -1;
    private static final String[] PROPERTIES = new String[]{"autorefresh", "basepath", "defaultpropertytype", "errorproperty", "failureproperty", "haltonerror", "haltonfailure", "host", "port", "protocol", "resultpath", "saveprefix", "saveresponse", "showhtmlparseroutput", "summary", "timeout"};

    public Configuration() {
        this.fHaltOnError = true;
        this.fHaltOnFailure = true;
    }

    public void init() {
        this.configureDefaultFromProjectProperties();
    }

    public Configuration(WebtestTask testSpec) {
        this.fSummary = true;
        this.fSaveResponse = true;
        this.fErrorProperty = "webtest.error";
        this.fFailureProperty = "webtest.failure";
        this.fShowHtmlParserOutput = true;
        this.setProject(testSpec.getProject());
        this.setOwningTarget(testSpec.getOwningTarget());
        this.init();
    }

    public void execute() throws BuildException {
        this.configureDefaultFromProjectProperties();
        if (this.getResultpath() == null) {
            this.setResultpath(this.getProject().resolveFile("webtest-results"));
        }
        this.prepareResultDir(this.getResultpath());
        if (this.isSummary()) {
            Checker.assertTrue(this.getResultFile() != null, "Result file cannot be null when writing summary");
            this.fSummaryFile = new File(this.getWebTestResultDir(), this.getResultFile());
            LOG.debug((Object)("Result file: " + this.fSummaryFile.getAbsolutePath()));
        }
        this.setupWebClient();
    }

    protected void setupWebClient() {
        this.fContext.setWebClient(this.createWebClient());
    }

    private void configureDefaultFromProjectProperties() {
        HashSet<String> existingProps = new HashSet<String>();
        if (this.getRuntimeConfigurableWrapper() != null) {
            Iterator iter = this.getRuntimeConfigurableWrapper().getAttributeMap().keySet().iterator();
            while (iter.hasNext()) {
                existingProps.add(((String)iter.next()).toLowerCase());
            }
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper((Project)this.getProject(), ((Object)((Object)this)).getClass());
        for (int i = 0; i < PROPERTIES.length; ++i) {
            String propValue;
            String propName = PROPERTIES[i];
            if (existingProps.contains(propName) || (propValue = this.getProject().getProperty("wt.config." + propName)) == null) continue;
            LOG.info((Object)("Using " + propName + " from project property wt.config." + propName + ": " + propValue));
            ih.setAttribute(this.getProject(), (Object)this, propName, propValue);
        }
    }

    void prepareResultDir(File resultDir) {
        if (this.isSummary() || this.isSaveResponse()) {
            if (resultDir.exists() && !resultDir.isDirectory()) {
                throw new BuildException("Result dir is not a directory: " + resultDir.getAbsolutePath());
            }
            this.fWebtestResultDir = this.computeSubFolder(resultDir);
            LOG.info((Object)("Creating result directory: " + this.fWebtestResultDir.getAbsolutePath()));
            if (!this.fWebtestResultDir.mkdirs()) {
                throw new BuildException("Failed to create result dir: " + this.fWebtestResultDir.getAbsolutePath());
            }
        } else {
            LOG.warn((Object)("Result dir '" + resultDir.getName() + "' not created (may not be needed), may cause problems if individual steps set save attribute"));
        }
    }

    protected File computeSubFolder(File _resultDir) {
        if (this.resultFolderIndex == -1) {
            this.resultFolderIndex = this.getResultFolderIndex(_resultDir);
        }
        String prefix = StringUtils.leftPad((String)String.valueOf(this.resultFolderIndex), (int)3, (char)'0');
        String fixedTestName = WordUtils.capitalize((String)this.fContext.getWebtest().getName()).replaceAll("\\W", "");
        String name = prefix + "_" + fixedTestName;
        int dirNameMaxLength = 20;
        return new File(_resultDir, StringUtils.left((String)name, (int)20));
    }

    public void setResultFolderIndex(int index) {
        this.resultFolderIndex = index;
    }

    protected int getResultFolderIndex(File _resultDir) {
        int lastIndex = 0;
        File[] children = _resultDir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File f = children[i];
                if (!f.getName().matches("\\d{3}_.*")) continue;
                int index = Integer.parseInt(f.getName().substring(0, 3));
                lastIndex = Math.max(lastIndex, index);
            }
        }
        return lastIndex + 1;
    }

    public File getSummaryFile() {
        return this.fSummaryFile;
    }

    public void addHeader(Header header) {
        this.fHeaderList.add(header);
    }

    public List getHeaderList() {
        return this.fHeaderList;
    }

    public void addOption(Option option) {
        this.fOptionList.add(option);
    }

    public List getOptionList() {
        return this.fOptionList;
    }

    public String getBasePath() {
        return this.fBasePath;
    }

    public String getUserAgent() {
        LOG.debug((Object)("Headers: " + this.getHeaderList()));
        Iterator iter = this.getHeaderList().iterator();
        while (iter.hasNext()) {
            Header elt = (Header)iter.next();
            if ("User-Agent".equals(elt.getName())) {
                LOG.debug((Object)("Found User-Agent header: " + elt.getValue()));
                return elt.getValue();
            }
            LOG.debug((Object)("Not User-Agent header: " + elt.getName()));
        }
        return null;
    }

    private boolean isDefaultPort() {
        return PROTOCOL_HTTP.equals(this.getProtocol()) && 80 == this.getPort() || PROTOCOL_HTTPS.equals(this.getProtocol()) && 443 == this.getPort();
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public String getProtocol() {
        return this.fProtocol;
    }

    File getResultpath() {
        return this.fResultPath;
    }

    public File getWebTestResultDir() {
        return this.fWebtestResultDir;
    }

    public String getSavePrefix() {
        return this.fSavePrefix;
    }

    public String getUrlForPage(String page) {
        int index = StringUtils.indexOf((String)page, (String)"://");
        if (index > -1 && index < 6 || page != null && page.toLowerCase().startsWith("file:/")) {
            return page;
        }
        if (PROTOCOL_FILE.equals(this.getProtocol())) {
            return this.createFileBasedUrl(page);
        }
        return this.createNetworkBasedUrl(page);
    }

    private String createFileBasedUrl(String page) {
        return this.getProtocol() + ":" + Configuration.combineBasePathAndPage(this.getBasePath(), page);
    }

    private String createNetworkBasedUrl(String page) {
        StringBuffer url = new StringBuffer(this.getProtocol());
        url.append("://");
        url.append(this.getHost());
        if (!this.isDefaultPort()) {
            url.append(":");
            url.append(this.getPort());
        }
        url.append(Configuration.combineBasePathAndPage(this.getBasePath(), page));
        return url.toString();
    }

    private static String combineBasePathAndPage(String basePath, String page) {
        String basePathClean = StringUtils.strip((String)basePath, (String)URL_SEPARATOR);
        basePathClean = StringUtils.isEmpty((String)basePathClean) ? "" : URL_SEPARATOR + basePathClean;
        String pageClean = StringUtils.stripStart((String)page, (String)URL_SEPARATOR);
        pageClean = StringUtils.isEmpty((String)pageClean) ? "" : URL_SEPARATOR + pageClean;
        return basePathClean + pageClean;
    }

    public boolean isSaveResponse() {
        return this.fSaveResponse;
    }

    public boolean isSummary() {
        return this.fSummary;
    }

    public void setSavePrefix(String savePrefix) {
        this.fSavePrefix = savePrefix;
    }

    public void setBasepath(String newBasePath) {
        this.fBasePath = newBasePath;
    }

    public void setHost(String newHost) {
        this.fHost = newHost;
    }

    public void setPort(int newPort) {
        this.fPort = newPort;
    }

    public void setProtocol(String newProtocol) {
        this.fProtocol = newProtocol;
    }

    public void setResultpath(File newResultPath) {
        this.fResultPath = newResultPath;
    }

    public void setSaveresponse(boolean newSaveResponse) {
        this.fSaveResponse = newSaveResponse;
    }

    public void setSummary(boolean newSummary) {
        this.fSummary = newSummary;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.fHaltOnError = haltOnError;
    }

    public void setHaltonfailure(boolean haltOnFailure) {
        this.fHaltOnFailure = haltOnFailure;
    }

    public void setErrorProperty(String errorProperty) {
        this.fErrorProperty = errorProperty;
    }

    public void setFailureProperty(String failureProperty) {
        this.fFailureProperty = failureProperty;
    }

    public String getFailureProperty() {
        return this.fFailureProperty;
    }

    public String getErrorProperty() {
        return this.fErrorProperty;
    }

    public String getDefaultPropertyType() {
        return this.fDefaultPropertyType;
    }

    public void setDefaultPropertyType(String type) {
        this.fDefaultPropertyType = type;
    }

    public void setShowhtmlparseroutput(boolean showParserOutput) {
        this.fShowHtmlParserOutput = showParserOutput;
    }

    public boolean isShowHtmlParserOutput() {
        return this.fShowHtmlParserOutput;
    }

    public boolean isHaltOnFailure() {
        return this.fHaltOnFailure;
    }

    public boolean isHaltOnError() {
        return this.fHaltOnError;
    }

    public Map getParameterDictionary() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", this.getHost());
        map.put("protocol", this.getProtocol());
        map.put("port", String.valueOf(this.getPort()));
        map.put("timeout", String.valueOf(this.getTimeout()));
        map.put("basepath", this.getBasePath());
        map.put("resultpath", this.getResultpath());
        map.put("summary", this.isSummary() ? "yes" : "no");
        map.put("saveresponse", this.isSaveResponse() ? "yes" : "no");
        map.put("saveprefix", this.getSavePrefix());
        map.put("haltonerror", this.isHaltOnError() ? "yes" : "no");
        map.put("haltonfailure", this.isHaltOnFailure() ? "yes" : "no");
        MapUtil.putIfNotNull(map, "errorproperty", this.getErrorProperty());
        MapUtil.putIfNotNull(map, "failureproperty", this.getFailureProperty());
        MapUtil.putIfNotNull(map, "defaultpropertytype", this.getDefaultPropertyType());
        map.put("autorefresh", this.getAutoRefresh());
        map.put("showhtmlparseroutput", this.isShowHtmlParserOutput() ? "yes" : "no");
        map.put("resultfile", this.getResultFile());
        return map;
    }

    public String getResultFile() {
        return this.fResultFile;
    }

    public void setResultfile(String resultFile) {
    }

    public void setPropertyHandler(IPropertyHandler propertyHandler) {
        this.fPropertyHandler = propertyHandler;
    }

    public String getExternalProperty(String name) {
        if (this.fPropertyHandler == null) {
            throw new IllegalStateException("No property handler configured!");
        }
        return this.fPropertyHandler.getProperty(name);
    }

    public String getAutoRefresh() {
        return this.fAutoRefresh;
    }

    public void setAutoRefresh(String str) {
        this.fAutoRefresh = str;
    }

    public void setContext(Context context) {
        this.fContext = context;
    }

    public WebClient createWebClient() {
        Configuration cfg = this;
        String strUserAgent = cfg.getUserAgent();
        BrowserVersion browserVersion = Configuration.setupBrowserVersion(strUserAgent);
        WebClient webClient = Configuration.setupWebClient(browserVersion);
        webClient.setTimeout(this.getTimeout() * 1000);
        Configuration.setupHtmlParser(webClient, cfg);
        Configuration.setupRefreshHandler(webClient, cfg);
        webClient.setThrowExceptionOnScriptError(true);
        WebClient.setIgnoreOutsideContent((boolean)true);
        Configuration.setupHttpHeaders(webClient, cfg);
        Configuration.setupOptions(webClient, cfg);
        this.configurePageCreator(webClient);
        return webClient;
    }

    protected void configurePageCreator(WebClient webClient) {
        DefaultPageCreator pageCreator = new DefaultPageCreator(){

            public Page createPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
                String contentType = webResponse.getContentType().toLowerCase();
                if ("application/pdf".equals(contentType)) {
                    PdfBoxPDFPage newPage = new PdfBoxPDFPage(webResponse, webWindow);
                    webWindow.setEnclosedPage((Page)newPage);
                    return newPage;
                }
                return super.createPage(webResponse, webWindow);
            }
        };
        webClient.setPageCreator((PageCreator)pageCreator);
    }

    private static BrowserVersion setupBrowserVersion(String strUserAgent) {
        BrowserVersion browserVersion;
        if (strUserAgent == null) {
            browserVersion = BrowserVersion.INTERNET_EXPLORER_6_0;
            LOG.info((Object)("Surfing with browser " + browserVersion.getUserAgent()));
        } else {
            BrowserVersion baseBrowser = strUserAgent.indexOf("Gecko") != -1 ? BrowserVersion.FIREFOX_2 : (strUserAgent.indexOf("Netscape") != -1 ? new BrowserVersion("Netscape", "5.0 (Windows; en-US)", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US;rv:0.9.4.1) Gecko/20020508 Netscape6/6.2.3", "1.2", 6.0f) : BrowserVersion.INTERNET_EXPLORER_6_0);
            browserVersion = new BrowserVersion(baseBrowser.getApplicationName(), baseBrowser.getApplicationVersion(), strUserAgent, baseBrowser.getJavaScriptVersion(), baseBrowser.getBrowserVersionNumeric());
            LOG.info((Object)("Using browser version (" + browserVersion.getApplicationName() + ", " + browserVersion.getApplicationVersion() + ", " + strUserAgent + ", " + browserVersion.getJavaScriptVersion() + ", " + browserVersion.getBrowserVersionNumeric() + "). If the javascript support is not as expected, then it's time to go into the sources"));
        }
        return browserVersion;
    }

    static WebClient setupWebClient(BrowserVersion browserVersion) {
        WebClient webClient;
        DefaultCredentialsProvider credentialProvider = new DefaultCredentialsProvider();
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && proxyHost.length() > 0) {
            int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            LOG.info((Object)("Configuring proxy from http.proxyHost* system properties: " + proxyHost + ":" + proxyPort));
            webClient = new WebClient(browserVersion, proxyHost, proxyPort);
            Configuration.configureProxy(webClient, credentialProvider);
        } else {
            webClient = new WebClient(browserVersion);
        }
        webClient.setCredentialsProvider((CredentialsProvider)credentialProvider);
        return webClient;
    }

    static void configureProxy(WebClient webClient, DefaultCredentialsProvider credentialProvider) {
        String nonProxyHostsSetting = System.getProperty("http.nonProxyHosts");
        LOG.info((Object)("Configuring proxy from http.nonProxyHosts system property: " + nonProxyHostsSetting));
        if (nonProxyHostsSetting != null) {
            String[] nonProxyHosts = nonProxyHostsSetting.split("\\|");
            for (int i = 0; i < nonProxyHosts.length; ++i) {
                String nonProxyHost = nonProxyHosts[i];
                nonProxyHost = nonProxyHost.replaceAll("\\.", "\\\\.");
                nonProxyHost = nonProxyHost.replaceAll("\\*", ".*");
                LOG.debug((Object)("addHostsToProxyBypass: >" + nonProxyHost + "<"));
                webClient.addHostsToProxyBypass(nonProxyHost);
            }
        }
        if (System.getProperty("http.proxyUser") != null) {
            String proxyUser = System.getProperty("http.proxyUser");
            String proxyPassword = System.getProperty("http.proxyPassword");
            LOG.info((Object)("Configuring proxy credentials from http.proxyHost* system properties: " + proxyUser + ", " + proxyPassword));
            credentialProvider.addProxyCredentials(proxyUser, proxyPassword);
        }
    }

    private static void setupHtmlParser(WebClient webClient, Configuration cfg) {
        if (cfg.isShowHtmlParserOutput()) {
            webClient.setHTMLParserListener((HTMLParserListener)new HtmlParserMessage.MessageCollector());
            LOG.debug((Object)"Configured a parser listener to collect messages generated while parsing html");
        } else {
            LOG.debug((Object)"showHtmlParserOutput is off, no listener configured");
        }
    }

    private static void setupRefreshHandler(WebClient webClient, Configuration cfg) {
        int acceptedRefreshDelay;
        boolean bRefreshAll;
        boolean bUseDelay;
        if (cfg.getAutoRefresh().matches("\\d+")) {
            bUseDelay = true;
            bRefreshAll = false;
            acceptedRefreshDelay = Integer.parseInt(cfg.getAutoRefresh());
        } else {
            bUseDelay = false;
            bRefreshAll = Project.toBoolean((String)cfg.getAutoRefresh());
            acceptedRefreshDelay = 0;
        }
        LOG.debug((Object)("Configuring RefreshHandler (refreshAll: " + bRefreshAll + ", useDelay: " + bUseDelay + ", refreshDelay: " + acceptedRefreshDelay));
        RefreshHandler refreshHandler = new RefreshHandler(){

            public void handleRefresh(Page page, URL url, int iTimeBeforeRefresh) throws IOException {
                boolean bRefresh;
                boolean bl = bRefresh = bRefreshAll || bUseDelay && iTimeBeforeRefresh <= acceptedRefreshDelay;
                if (bRefresh) {
                    LOG.info((Object)("Performing refresh to " + url + " (delay: " + iTimeBeforeRefresh + ") according to configuration"));
                    WebWindow window = page.getEnclosingWindow();
                    if (window == null) {
                        return;
                    }
                    WebClient client = window.getWebClient();
                    client.getPage(window, new WebRequestSettings(url));
                } else {
                    LOG.info((Object)("no refresh performed to " + url + " (delay: " + iTimeBeforeRefresh + ") according to configuration"));
                }
            }
        };
        webClient.setRefreshHandler(refreshHandler);
    }

    private static void setupHttpHeaders(WebClient webClient, Configuration cfg) {
        if (cfg.getHeaderList().size() > 0) {
            LOG.info((Object)("Configuring " + cfg.getHeaderList().size() + " HTTP header field(s)"));
        }
        Iterator iter = cfg.getHeaderList().iterator();
        while (iter.hasNext()) {
            Header header = (Header)iter.next();
            if ("User-Agent".equals(header.getName())) {
                LOG.info((Object)"Skipped User-Agent header as it has already been configured in the BrowserVersion");
                continue;
            }
            webClient.addRequestHeader(header.getName(), header.getValue());
            LOG.info((Object)("Configured header \"" + header.getName() + "\": " + header.getValue()));
        }
    }

    private static void setupOptions(WebClient webClient, Configuration cfg) {
        List options = cfg.getOptionList();
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            Option option = (Option)iter.next();
            boolean found = Configuration.tryBooleanCallingMethod(option, webClient);
            if (!found) {
                found = Configuration.tryIntCallingMethod(option, webClient);
            }
            if (found) continue;
            LOG.warn((Object)("Unknown option <" + option.getName() + ">. Ignored."));
        }
    }

    private static boolean tryBooleanCallingMethod(Option option, Object optionObject) {
        Class[] booleanClass = new Class[]{Boolean.TYPE};
        try {
            Configuration.tryCallMethod(optionObject, option, booleanClass, new Object[]{Boolean.valueOf(option.getValue())});
            return true;
        }
        catch (Exception e) {
            LOG.info((Object)("Exception while trying to set boolean option: " + e.getMessage()));
            return false;
        }
    }

    private static boolean tryIntCallingMethod(Option option, Object optionObject) {
        Class[] intClass = new Class[]{Integer.TYPE};
        try {
            Configuration.tryCallMethod(optionObject, option, intClass, new Object[]{Integer.valueOf(option.getValue())});
            return true;
        }
        catch (Exception e) {
            LOG.info((Object)("Exception while trying to set integer option: " + e.getMessage()));
            return false;
        }
    }

    private static void tryCallMethod(Object optionObject, Option option, Class[] typeSpec, Object[] params) throws Exception {
        Method method = optionObject.getClass().getDeclaredMethod("set" + option.getName(), typeSpec);
        method.invoke(optionObject, params);
        LOG.info((Object)("set option <" + option.getName() + "> to value <" + option.getValue() + ">"));
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    public void setTimeout(int timeout) {
        this.fTimeout = timeout;
    }

    public void setEasyAjax(boolean b) {
        this.fEasyAjax = b;
    }

    public boolean isEasyAjax() {
        return this.fEasyAjax;
    }
}

