/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.steps.form.AbstractSetFieldStep;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StoreInputFieldAttribute
extends BaseStoreStep {
    private String fFieldName;
    private String fFieldValue;
    private String fAttributeName;
    private String fFieldIndex;
    private String fFormName;

    public void doExecute() throws Exception {
        List htmlInputs = this.findHtmlElements(this.getContext());
        HtmlInput htmlInputElmt = (HtmlInput)AbstractSetFieldStep.selectField(htmlInputs, this.fFieldIndex, this);
        String retval = htmlInputElmt.getAttributeValue(this.fAttributeName);
        if (retval == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            retval = "false";
        } else if (retval == HtmlElement.ATTRIBUTE_VALUE_EMPTY || retval.length() == 0) {
            retval = "true";
        }
        this.storeProperty(retval);
    }

    private List findHtmlElements(Context context) throws Exception {
        ArrayList fields;
        if (this.fFormName != null) {
            HtmlForm form = FormUtil.findFormForField(context, this.fFormName, "input", null, this.fFieldName, this);
            fields = new ArrayList(form.getInputsByName(this.fFieldName));
        } else {
            fields = new ArrayList(((HtmlPage)context.getCurrentResponse()).getDocumentHtmlElement().getHtmlElementsByAttribute("input", "name", this.fFieldName));
        }
        if (this.fFieldValue != null) {
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                HtmlInput input = (HtmlInput)iter.next();
                if (this.fFieldValue.equals(input.getValueAttribute())) continue;
                iter.remove();
            }
        }
        return fields;
    }

    public void setName(String name) {
        this.fFieldName = name;
    }

    public String getName() {
        return this.fFieldName;
    }

    public void setValue(String value) {
        this.fFieldValue = value;
    }

    public String getValue() {
        return this.fFieldValue;
    }

    public void setAttributeName(String name) {
        this.fAttributeName = name;
    }

    public String getAttributeName() {
        return this.fAttributeName;
    }

    public void setFieldIndex(String index) {
        this.fFieldIndex = index;
    }

    public String getFieldIndex() {
        return this.fFieldIndex;
    }

    public void setPropertyName(String name) {
        this.setProperty(name);
    }

    public void setFormName(String formName) {
        this.fFormName = formName;
    }

    public String getFormName() {
        return this.fFormName;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getProperty(), "property");
        this.nullParamCheck(this.getName(), "name");
        this.nullParamCheck(this.getAttributeName(), "attributeName");
        this.optionalIntegerParamCheck(this.getFieldIndex(), "fieldIndex", false);
        this.nullResponseCheck();
    }
}

