/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.extension.VerifyContentDiff;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VerifyContentTextDiff
implements VerifyContentDiff {
    private static final int CONTEXT_SIZE = 3;
    final List deltas = new ArrayList();
    private List hashValuesA;
    private List hashValuesB;
    protected String[] tabReference;
    protected String[] tabActual;

    public String compare(WebResponse reference, WebResponse actual, String referenceLabel, String actualLabel) {
        String referenceText = reference.getContentAsString();
        String actualText = actual.getContentAsString();
        return this.produceTextDiffMessage(referenceText, actualText, referenceLabel, actualLabel);
    }

    protected void reset() {
        this.deltas.clear();
        this.hashValuesA = null;
        this.hashValuesB = null;
        this.tabReference = null;
        this.tabActual = null;
    }

    String produceTextDiffMessage(String referenceText, String actualText, String referenceLabel, String actualLabel) {
        this.reset();
        this.tabReference = referenceText.split("[\\n\\r]+");
        this.tabActual = actualText.split("[\\n\\r]+");
        this.preProcess();
        this.compare(0, this.tabReference.length, 0, this.tabActual.length);
        if (this.deltas.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("--- " + referenceLabel + "\n");
        sb.append("+++ " + actualLabel + "\n");
        this.printDiff(sb);
        return sb.toString();
    }

    protected void preProcess() {
        this.hashValuesA = this.computeHash(this.tabReference);
        this.hashValuesB = this.computeHash(this.tabActual);
    }

    private void printDiff(StringBuffer sb) {
        Iterator iter = this.getContexts(this.deltas).iterator();
        while (iter.hasNext()) {
            Context context = (Context)iter.next();
            context.print(sb);
        }
    }

    private List getContexts(List _deltas) {
        if (_deltas.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Context> contexts = new ArrayList<Context>();
        Context context = new Context();
        contexts.add(context);
        Iterator iter = _deltas.iterator();
        while (iter.hasNext()) {
            Delta delta = (Delta)iter.next();
            if (!context.accept(delta)) {
                context = new Context();
                contexts.add(context);
            }
            context.addDelta(delta);
        }
        return contexts;
    }

    private void compare(int startA, int endA, int startB, int endB) {
        while (startA < endA && startB < endB && this.sameContent(startA, startB)) {
            ++startB;
            ++startA;
        }
        while (endA > startA && endB > startB && this.sameContent(endA - 1, endB - 1)) {
            --endB;
            --endA;
        }
        if (startA == endA) {
            for (int i = startB; i < endB; ++i) {
                this.deltas.add(new Delta(startA, i, 'B'));
            }
        } else if (startB == endB) {
            for (int i = startA; i < endA; ++i) {
                this.deltas.add(new Delta(i, startB, 'A'));
            }
        } else if (startA == endA - 1 && startB == endB - 1) {
            if (!this.sameContent(startA, startB)) {
                this.deltas.add(new Delta(startA, startB, 'A'));
                this.deltas.add(new Delta(startA, startB, 'B'));
            }
        } else {
            MidPoint splitPoints = this.retrieveMidPoint(startA, endA, startB, endB);
            this.compare(startA, splitPoints.lineA, startB, splitPoints.lineB);
            this.compare(splitPoints.lineA, endA, splitPoints.lineB, endB);
        }
    }

    protected boolean sameContent(int posA, int posB) {
        return this.hashValuesA.get(posA).equals(this.hashValuesB.get(posB));
    }

    private MidPoint retrieveMidPoint(int startA, int endA, int startB, int endB) {
        int midA = (endA + startA) / 2;
        int midB = (endB + startB) / 2;
        int incrementA = -1;
        for (int index1 = midA; index1 >= startA && index1 < endA; index1 += incrementA) {
            int incrementB = -1;
            for (int indexB = midB; indexB >= startB && indexB < endB; indexB += incrementB) {
                if (this.sameContent(index1, indexB)) {
                    return new MidPoint(index1, indexB);
                }
                incrementB = VerifyContentTextDiff.nextIncrement(incrementB);
            }
            incrementA = VerifyContentTextDiff.nextIncrement(incrementA);
        }
        return new MidPoint(midA, midB);
    }

    static int nextIncrement(int increment) {
        if (increment < 0) {
            return -increment + 1;
        }
        return -increment - 1;
    }

    private List computeHash(String[] tab) {
        ArrayList<Integer> hashValues = new ArrayList<Integer>(tab.length);
        for (int i = 0; i < tab.length; ++i) {
            hashValues.add(new Integer(tab[i].hashCode()));
        }
        return hashValues;
    }

    private class Context {
        final List deltas = new ArrayList();
        int firstLineA = -1;
        int lastLineA = -1;
        private int firstA = -1;
        private int lastA = -1;
        private Delta firstDelta;

        private Context() {
        }

        public boolean accept(Delta _delta) {
            if (_delta.type == 'B') {
                return true;
            }
            if (this.firstLineA == -1) {
                return true;
            }
            return _delta.lineA <= this.lastLineA;
        }

        public void addDelta(Delta _delta) {
            if (this.firstDelta == null) {
                this.firstDelta = _delta;
            }
            this.deltas.add(_delta);
            if (_delta.type == 'A') {
                if (this.firstLineA == -1) {
                    this.firstA = _delta.lineA;
                    this.firstLineA = Math.max(1, this.firstA - 3);
                }
                this.lastA = _delta.lineA;
                this.lastLineA = Math.min(VerifyContentTextDiff.this.tabReference.length, this.lastA + 3);
            }
        }

        int getFirstContextLineB() {
            return Math.max(1, this.firstDelta.lineB - 3);
        }

        int getLastContextLineB() {
            Delta lastDelta = (Delta)this.deltas.get(this.deltas.size() - 1);
            return Math.min(VerifyContentTextDiff.this.tabActual.length, lastDelta.lineB + 3);
        }

        void print(StringBuffer sb) {
            sb.append("@@ -");
            sb.append(this.firstLineA);
            sb.append(",");
            sb.append(this.lastLineA - this.firstLineA + 1);
            sb.append(" +");
            sb.append(this.getFirstContextLineB());
            sb.append(",");
            sb.append(this.getLastContextLineB() - this.getFirstContextLineB() + 1);
            sb.append(" @@");
            sb.append("\n");
            for (int i = this.firstLineA; i < this.firstA; ++i) {
                sb.append(" ").append(VerifyContentTextDiff.this.tabReference[i]).append("\n");
            }
            Iterator iter = this.deltas.iterator();
            while (iter.hasNext()) {
                Delta delta = (Delta)iter.next();
                if (delta.type == 'B') {
                    sb.append("+").append(VerifyContentTextDiff.this.tabActual[delta.lineB]).append("\n");
                    continue;
                }
                sb.append("-").append(VerifyContentTextDiff.this.tabReference[delta.lineA]).append("\n");
            }
            for (int i = this.lastA + 1; i < this.lastLineA; ++i) {
                sb.append(" ").append(VerifyContentTextDiff.this.tabReference[i]).append("\n");
            }
        }
    }

    private static class Delta {
        final int lineA;
        final int lineB;
        final char type;

        public Delta(int _lineA, int _lineB, char _type) {
            this.lineA = _lineA;
            this.lineB = _lineB;
            this.type = _type;
        }
    }

    static class MidPoint {
        final int lineA;
        final int lineB;

        public MidPoint(int _first, int _second) {
            this.lineA = _first;
            this.lineB = _second;
        }
    }
}

