/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet;

import com.canoo.webtest.extension.applet.AppletTag;
import com.canoo.webtest.extension.applet.ObjectTag;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class AbstractAppletTag
implements Serializable {
    private static final Logger LOG = Logger.getLogger((Class)AbstractAppletTag.class);
    private final URL fBase;
    private final Map fParameter = new HashMap();
    public static final String ATTR_WIDTH = "WIDTH";
    public static final String ATTR_HEIGHT = "HEIGHT";
    public static final String ATTR_CODE = "CODE";
    public static final String ATTR_NAME = "NAME";
    public static final String ATTR_CODEBASE = "CODEBASE";
    public static final String ATTR_OBJECT = "OBJECT";
    public static final String ATTR_ARCHIVE = "ARCHIVE";
    static final List PARAM = new ArrayList();

    public AbstractAppletTag(String base) throws MalformedURLException {
        this.addParameterObject(ATTR_ARCHIVE, new ArrayList());
        this.addParameterLength(ATTR_WIDTH, "0");
        this.addParameterLength(ATTR_HEIGHT, "0");
        this.fBase = AbstractAppletTag.makeDirectoryURL(base);
        this.addParameterObject(ATTR_CODEBASE, this.fBase);
    }

    protected static URL makeDirectoryURL(String base) throws MalformedURLException {
        URL url = new URL(base);
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), path.substring(0, 1 + lastSlash));
    }

    public void setArchive(String value) {
        List archive = (List)this.getParameterObject(ATTR_ARCHIVE);
        StringTokenizer st = new StringTokenizer(value, ", ");
        while (st.hasMoreTokens()) {
            archive.add(st.nextToken());
        }
    }

    public List getArchive() {
        return (List)this.getParameterObject(ATTR_ARCHIVE);
    }

    public String getCode() {
        String code = this.getParameter(ATTR_CODE);
        if (code.endsWith(".class")) {
            return code.substring(0, code.length() - ".class".length());
        }
        return code;
    }

    public URL getBase() {
        return this.fBase;
    }

    public URL getCodebase() {
        return (URL)this.getParameterObject(ATTR_CODEBASE);
    }

    public void setCodebase(String codeBase) throws MalformedURLException {
        URL codebase = new URL(this.fBase, codeBase + (codeBase.endsWith("/") ? "" : "/"));
        if (!codebase.getHost().equals(this.fBase.getHost())) {
            LOG.info((Object)"According to the JavaPlugin, the URL can be relative or absolute but it should be in the domain of the current document.");
        }
        if (!codebase.getPath().startsWith(this.fBase.getPath())) {
            LOG.info((Object)"According to HTML 4.0, the codebase may only refer to subdirectories of the directory containing the current document");
        }
        this.addParameterObject(ATTR_CODEBASE, codebase);
    }

    public String getHeight() {
        return this.getParameter(ATTR_HEIGHT);
    }

    public String getName() {
        return this.getParameter(ATTR_NAME);
    }

    public void addParameter(String name, String value) throws MalformedURLException {
        if (ATTR_WIDTH.equalsIgnoreCase(name) || ATTR_HEIGHT.equalsIgnoreCase(name)) {
            this.addParameterLength(name, value);
        } else if (ATTR_CODEBASE.equalsIgnoreCase(name)) {
            this.setCodebase(value);
        } else if (ATTR_ARCHIVE.equalsIgnoreCase(name)) {
            this.setArchive(value);
        } else {
            this.addParameterObject(name, value);
        }
    }

    protected void addParameterObject(String key, Object base) {
        this.fParameter.put(key.toUpperCase(Locale.US), base);
    }

    private Object getParameterObject(String key) {
        return this.fParameter.get(key.toUpperCase(Locale.US));
    }

    public void addParameterLength(String name, String length) throws NumberFormatException {
        if (length.endsWith("%")) {
            Integer.parseInt(length.substring(0, length.length() - 1));
        } else {
            Integer.parseInt(length);
        }
        this.addParameterObject(name, length);
    }

    public String getParameter(String name) {
        Object value = this.fParameter.get(name.toUpperCase(Locale.US));
        if (value == null) {
            return null;
        }
        if (value instanceof URL) {
            return ((URL)value).toExternalForm();
        }
        if (value instanceof List) {
            StringBuffer arc = new StringBuffer();
            Iterator iterator = ((List)value).iterator();
            while (iterator.hasNext()) {
                arc.append((String)iterator.next()).append(", ");
            }
            if (arc.length() > 2) {
                arc.setLength(arc.length() - 2);
            }
            return arc.toString();
        }
        return (String)value;
    }

    public String getWidth() {
        return this.getParameter(ATTR_WIDTH);
    }

    public URL[] getArchiveURL() throws MalformedURLException {
        List archive = (List)this.getParameterObject(ATTR_ARCHIVE);
        URL[] urls = new URL[archive.size() + 1];
        URL codebase = this.getCodebase();
        for (int i = 0; i < urls.length - 1; ++i) {
            urls[i] = new URL(codebase, (String)archive.get(i));
            LOG.info((Object)urls[i].toExternalForm());
        }
        urls[urls.length - 1] = codebase;
        return urls;
    }

    /*
     * WARNING - void declaration
     */
    static AbstractAppletTag newInstance(URL base, HtmlElement appletNode) throws NoSuchFieldException, MalformedURLException, IllegalArgumentException {
        void var2_2;
        AbstractAppletTag appletTag;
        if (appletNode instanceof HtmlApplet) {
            appletTag = new AppletTag(base.toExternalForm());
        } else if (appletNode instanceof HtmlObject) {
            appletTag = new ObjectTag(base.toExternalForm());
        } else {
            throw new IllegalArgumentException("Don't know how to handle element <" + appletNode.getTagName() + ">.");
        }
        var2_2.addsAllAttributes(appletNode);
        var2_2.addsAllParameters(appletNode);
        return var2_2;
    }

    protected abstract void addsAllAttributes(HtmlElement var1) throws NoSuchFieldException, MalformedURLException;

    protected void addsAllParameters(HtmlElement appletNode) throws NoSuchFieldException, MalformedURLException {
        Iterator iterator = appletNode.getHtmlElementsByTagNames(PARAM).iterator();
        while (iterator.hasNext()) {
            HtmlElement paramNode = (HtmlElement)iterator.next();
            String name = paramNode.getAttributeValue("name");
            if (name == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                throw new NoSuchFieldException("Attribute name of param is missing.");
            }
            String value = paramNode.getAttributeValue("value");
            if (value == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                LOG.info((Object)("Skipping parameter named '" + name + "', it has no value."));
                continue;
            }
            this.addParameter(name, value);
        }
    }

    static {
        PARAM.add("param");
    }
}

