/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet;

import com.canoo.webtest.extension.applet.AbstractAppletTag;
import com.canoo.webtest.extension.applet.Parameter;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;

public class AppletPluginArguments
implements Serializable {
    private static final Logger LOG = Logger.getLogger((Class)AppletPluginArguments.class);
    static final URL[] EMPTY_URL_LIST = new URL[0];
    private URL[] fScenarioLocation;
    private String fScenario;
    private AbstractAppletTag fAppletTag;
    private final Map fArguments;
    private File fOutputFile;
    private boolean fSaveResponse;
    private File fSaveDirectory;
    private String fBaseWindowName;
    private final List fCookies = new ArrayList();

    public AppletPluginArguments() {
        this.fArguments = new HashMap();
        this.fScenarioLocation = EMPTY_URL_LIST;
    }

    public URL[] getScenarioLocation() {
        LOG.debug((Object)("get scenario location\n" + AppletPluginArguments.listURLs(this.fScenarioLocation)));
        return this.fScenarioLocation;
    }

    public void setScenarioLocation(URL[] newScenarioLocation) {
        URL[] scenarioLocation = newScenarioLocation;
        if (scenarioLocation == null) {
            scenarioLocation = EMPTY_URL_LIST;
        }
        LOG.debug((Object)("set scenario location\n" + AppletPluginArguments.listURLs(scenarioLocation)));
        this.fScenarioLocation = scenarioLocation;
    }

    private static String listURLs(URL[] scenarioLocation) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < scenarioLocation.length; ++i) {
            sb.append("   ").append(scenarioLocation[i].toExternalForm()).append("\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getScenario() {
        return this.fScenario;
    }

    public void setScenario(String scenario) {
        LOG.debug((Object)("set scenario " + scenario));
        this.fScenario = scenario;
    }

    public AbstractAppletTag getAppletTag() {
        return this.fAppletTag;
    }

    public void setAppletTag(AbstractAppletTag appletTag) {
        this.fAppletTag = appletTag;
    }

    public boolean hasArguments() {
        return !this.fArguments.isEmpty();
    }

    public void addArgument(Parameter parameter) {
        LOG.debug((Object)("add parameter " + parameter.getName() + " to " + parameter.getValue()));
        this.fArguments.put(parameter.getName(), parameter.getValue());
    }

    public String getArgument(String name) {
        return (String)this.fArguments.get(name);
    }

    public Iterator getArguments() {
        return this.fArguments.entrySet().iterator();
    }

    public void setOutputFile(File outputFile) {
        LOG.debug((Object)("set output file " + outputFile));
        this.fOutputFile = outputFile;
    }

    public File getOutputFile() {
        return this.fOutputFile;
    }

    public void setSaveResponse(boolean saveResponse) {
        LOG.debug((Object)("set save response " + saveResponse));
        this.fSaveResponse = saveResponse;
    }

    public boolean isSaveResponse() {
        return this.fSaveResponse;
    }

    public void setSaveDirectory(File saveDirectory) {
        LOG.debug((Object)("set save directory " + saveDirectory));
        this.fSaveDirectory = saveDirectory;
    }

    public File getSaveDirectory() {
        return this.fSaveDirectory;
    }

    public void setBaseWindowName(String baseWindowName) {
        LOG.debug((Object)("set base window name " + baseWindowName));
        this.fBaseWindowName = baseWindowName;
    }

    public String getBaseWindowName() {
        return this.fBaseWindowName;
    }

    public void addCookies(Cookie[] cookies) {
        this.fCookies.addAll(Arrays.asList(cookies));
    }

    public Cookie[] getCookies() {
        return this.fCookies.toArray(new Cookie[0]);
    }
}

