/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.jemmy;

import com.canoo.webtest.boundary.JemmyBoundary;
import com.canoo.webtest.extension.applet.runner.Context;
import java.net.URL;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class ContextOperator
implements Outputable,
Timeoutable {
    private TestOut fOutput;
    private Timeouts fTimeouts;
    private JemmyProperties fProperties;
    public static final String WAIT_TIMEOUT_NAME = "ContextOperator.WaitStateTimeout";
    private final Context fContext;

    public void setOutput(TestOut output) {
        this.fOutput = output;
    }

    public TestOut getOutput() {
        return this.fOutput;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.fTimeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.fTimeouts;
    }

    public JemmyProperties getProperties() {
        return this.fProperties;
    }

    public JemmyProperties setProperties(JemmyProperties properties) {
        JemmyProperties oldProperties = this.getProperties();
        this.fProperties = properties;
        return oldProperties;
    }

    public void waitState(Waitable state) {
        Waiter stateWaiter = new Waiter(state);
        stateWaiter.setTimeouts(this.getTimeouts().cloneThis());
        stateWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout(WAIT_TIMEOUT_NAME));
        stateWaiter.setOutput(this.getOutput().createErrorOutput());
        JemmyBoundary.tryWaitAction(stateWaiter, state, this.fContext);
    }

    public ContextOperator(Context context) {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setProperties(JemmyProperties.getProperties());
        this.fContext = context;
    }

    public void waitShowDocument() {
        this.waitShowDocument("_top");
    }

    public void waitShowDocument(String target) {
        this.getOutput().printLine("Wait any url in frame " + target);
        this.getOutput().printGolden("Wait any url in frame " + target);
        this.waitState(new WaitFrame(target));
    }

    public void waitShowDocument(URL url) {
        this.waitShowDocument(url, "_top");
    }

    public void waitShowDocument(URL url, String target) {
        this.getOutput().printLine("Wait \"" + url + "\" in frame " + target);
        this.getOutput().printGolden("Wait \"" + url + "\" in frame " + target);
        this.waitState(new WaitUrlInFrame(url, target));
    }

    public Context getContext() {
        return this.fContext;
    }

    static {
        Timeouts.initDefault((String)WAIT_TIMEOUT_NAME, (long)3600000L);
    }

    static class WaitUrlInFrame
    extends WaitFrame {
        private final URL fUrl;

        WaitUrlInFrame(URL url, String target) {
            super(target);
            this.fUrl = url;
        }

        public Object actionProduced(Object obj) {
            URL url = (URL)super.actionProduced(obj);
            if (this.fUrl.equals(url)) {
                return url;
            }
            return null;
        }

        public String getDescription() {
            return "Wait for showDocument(" + this.getTarget() + ", " + this.fUrl.toExternalForm() + ")";
        }
    }

    static class WaitFrame
    implements Waitable {
        private final String fTarget;

        WaitFrame(String target) {
            this.fTarget = target;
        }

        public Object actionProduced(Object obj) {
            return ((Context)obj).getAppletPluginResults().getFrames().get(this.getTarget());
        }

        public String getDescription() {
            return "Wait for showDocument(" + this.getTarget() + ", ...)";
        }

        public String getTarget() {
            return this.fTarget;
        }
    }
}

