/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner;

import com.canoo.webtest.boundary.AppletRunnerBoundary;
import com.canoo.webtest.extension.applet.AbstractAppletTag;
import com.canoo.webtest.extension.applet.AppletPluginArguments;
import com.canoo.webtest.extension.applet.AppletPluginResults;
import com.canoo.webtest.extension.applet.runner.AbstractAppletStub;
import com.canoo.webtest.extension.applet.runner.AbstractScenario;
import com.canoo.webtest.extension.applet.runner.AppletRunnerHelper;
import com.canoo.webtest.extension.applet.runner.Context;
import com.canoo.webtest.extension.applet.runner.LoggingOutputStream;
import com.canoo.webtest.extension.applet.runner.ScenarioRunner;
import com.canoo.webtest.extension.applet.runner.http.HttpURLConnection;
import com.canoo.webtest.util.FileUtil;
import java.applet.Applet;
import java.awt.Frame;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;

public class AppletRunner {
    private static final Logger LOG = Logger.getLogger((Class)AppletRunner.class);
    private static final Class[] PARAMETER_TYPES_SCENARIO_CONSTRUCTOR = new Class[]{AppletRunner.class, Frame.class};
    private static final Class[] PARAMETER_TYPES_APPLET_CONSTRUCTOR = new Class[0];
    private static final Object[] PARAMETER_APPLET_CONSTRUCTOR = new Object[0];
    public static final int EXIT_OK = 0;
    public static final int EXIT_ERROR_NO_APPLET_RUNNER = -1;
    public static final int EXIT_ERROR_INSTANTIATE_APPLET_RUNNER = -2;
    public static final int EXIT_ERROR_DURING_RUN = -3;
    public static final int EXIT_ERROR_ARGUMENT_IO = -4;
    public static final int EXIT_ERROR_ARGUMENT_CLASS = -5;
    private final AppletPluginArguments fAppletPluginArguments;
    private final Context fAppletContext;

    public static void main(String[] args) {
        JemmyProperties.setCurrentOutput((TestOut)new TestOut(System.in, new PrintWriter(new LoggingOutputStream(TestOut.class, LOG, (Priority)Level.INFO), true), new PrintWriter(new LoggingOutputStream(TestOut.class, LOG, (Priority)Level.WARN), true)));
        AppletPluginArguments appletPluginArguments = AppletRunner.readPluginArguments(args);
        HttpURLConnection.setCookies(appletPluginArguments.getCookies());
        try {
            new AppletRunner(appletPluginArguments).run();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            System.exit(-3);
        }
        System.exit(0);
    }

    private static AppletPluginArguments readPluginArguments(String[] args) {
        return new AppletRunnerHelper(-5, -4, new AppletRunnerBoundary()).readPluginArguments(args[0]);
    }

    public AppletRunner(AppletPluginArguments appletPluginArguments) {
        this.fAppletPluginArguments = appletPluginArguments;
        this.fAppletContext = new Context(new AppletPluginResults());
    }

    void run() throws Exception {
        AbstractAppletTag appletTag = this.fAppletPluginArguments.getAppletTag();
        AbstractAppletStub appletStub = this.fAppletContext.newStub(this.newApplet(appletTag), appletTag, this.fAppletPluginArguments);
        AbstractScenario scenario = this.newScenario(appletStub.getRootFrame());
        ScenarioRunner jemmyRunnable = new ScenarioRunner(scenario);
        this.internalRun(appletStub, jemmyRunnable);
    }

    void internalRun(AbstractAppletStub appletStub, ScenarioRunner jemmyRunnable) throws InterruptedException {
        appletStub.init();
        appletStub.show();
        appletStub.start();
        try {
            try {
                jemmyRunnable.startTest();
                jemmyRunnable.join();
                this.fAppletContext.getAppletPluginResults().setReturnValue((Integer)jemmyRunnable.getResult());
                if (jemmyRunnable.getException() != null) {
                    this.fAppletContext.getAppletPluginResults().setException(jemmyRunnable.getException());
                    LOG.error((Object)jemmyRunnable.getException().getMessage(), jemmyRunnable.getException());
                }
                AppletRunnerBoundary.storeJemmyExceptionIfNeeded(jemmyRunnable.getJemmyException(), this.fAppletContext);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Scenario " + this.fAppletPluginArguments.getScenario() + " interrupted"), (Throwable)e);
                throw e;
            }
            Object var5_3 = null;
            appletStub.stop();
            appletStub.destroy();
            this.writeArguments(this.fAppletContext.getAppletPluginResults());
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            appletStub.stop();
            appletStub.destroy();
            this.writeArguments(this.fAppletContext.getAppletPluginResults());
            throw throwable;
        }
    }

    protected void writeArguments(AppletPluginResults apr) {
        FileUtil.tryWriteObjectToFile(this.fAppletPluginArguments.getOutputFile(), apr, null);
    }

    AbstractScenario newScenario(Frame rootFrame) throws Exception {
        URLClassLoader classLoader = new URLClassLoader(this.fAppletPluginArguments.getScenarioLocation(), this.getClass().getClassLoader());
        Object object = AppletRunner.createObject(classLoader, this.fAppletPluginArguments.getScenario(), PARAMETER_TYPES_SCENARIO_CONSTRUCTOR, new Object[]{this, rootFrame});
        return (AbstractScenario)AppletRunnerBoundary.assertObjectHasCorrectClass(AbstractScenario.class, object, "Parameter scenario does not select a " + AbstractScenario.class.getName() + ": ");
    }

    Applet newApplet(AbstractAppletTag appletTag) throws Exception {
        URLClassLoader appletLoader = AppletRunnerBoundary.tryCreateUrlClassLoader(appletTag, null);
        Object object = AppletRunner.createObject(appletLoader, appletTag.getCode(), PARAMETER_TYPES_APPLET_CONSTRUCTOR, PARAMETER_APPLET_CONSTRUCTOR);
        return (Applet)AppletRunnerBoundary.assertObjectHasCorrectClass(Applet.class, object, "The xpath does not select an applet: ");
    }

    private static Object createObject(ClassLoader classLoader, String className, Class[] ctorParamType, Object[] ctorParam) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> aClass = Class.forName(className, true, classLoader);
        Constructor<?> constructor = aClass.getConstructor(ctorParamType);
        return constructor.newInstance(ctorParam);
    }

    public AppletPluginArguments getAppletPluginArguments() {
        return this.fAppletPluginArguments;
    }

    public Context getAppletContext() {
        return this.fAppletContext;
    }
}

