/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner;

import com.canoo.webtest.util.Checker;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingOutputStream
extends OutputStream {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean fHasBeenClosed;
    private byte[] fBuf = new byte[2048];
    private int fCount;
    private int fBufLength = this.fBuf.length;
    public static final int DEFAULT_BUFFER_LENGTH = 2048;
    private final Logger fLogger;
    private final Priority fPriority;
    private final String fLastFrameworkClassName;

    public LoggingOutputStream(Class lastFrameworkClass, Logger log, Priority priority) {
        Checker.assertNonNull(lastFrameworkClass, "lastFrameworkClass cannot be null");
        Checker.assertNonNull(log, "log cannot be null");
        Checker.assertNonNull(priority, "priority cannot be null");
        this.fPriority = priority;
        this.fLogger = log;
        this.fLastFrameworkClassName = lastFrameworkClass.getName();
    }

    public void close() {
        this.flush();
        this.fHasBeenClosed = true;
    }

    String getLastFrameworkClassName() {
        return this.fLastFrameworkClassName;
    }

    Priority getPriority() {
        return this.fPriority;
    }

    Logger getLogger() {
        return this.fLogger;
    }

    int getCount() {
        return this.fCount;
    }

    public void write(int b) throws IOException {
        if (this.fHasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (b == 0) {
            return;
        }
        if (this.fCount == this.fBufLength) {
            int newBufLength = this.fBufLength + 2048;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.fBuf, 0, newBuf, 0, this.fBufLength);
            this.fBuf = newBuf;
            this.fBufLength = this.fBuf.length;
        }
        this.fBuf[this.fCount++] = (byte)b;
    }

    public void flush() {
        if (this.fCount == 0) {
            return;
        }
        if (this.fCount == LINE_SEPARATOR.length() && (char)this.fBuf[0] == LINE_SEPARATOR.charAt(0) && (this.fCount == 1 || this.fCount == 2 && (char)this.fBuf[1] == LINE_SEPARATOR.charAt(1))) {
            this.reset();
            return;
        }
        this.fLogger.log(this.fLastFrameworkClassName, this.fPriority, (Object)new String(this.fBuf, 0, this.fCount), null);
        this.reset();
    }

    private void reset() {
        this.fCount = 0;
    }
}

