/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.applet.runner;

import org.apache.log4j.Logger;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.Scenario;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;

public class ScenarioRunner
extends ActionProducer
implements Timeoutable,
Outputable {
    private static final Logger LOG = Logger.getLogger((Class)ScenarioRunner.class);
    public static final String WHOLE_TEST_TIMEOUT_NAME = "ScenarioRunner.WholeTestTimeout";
    static final String ACTION_PRODUCER_MAX_ACTION_TIME_NAME = "ActionProducer.MaxActionTime";
    private Timeouts fTimeouts;
    private TestOut fOutput;
    private final Scenario fScenario;
    private JemmyException fJemmyException;
    static final String DESCRIPTION = "Jemmy scenario runner for Webtest's AppletRunner.";

    public ScenarioRunner(Scenario scenario) {
        super(true);
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.fScenario = scenario;
        this.setName("ScenarioRunner for " + this.fScenario.getClass().getName());
    }

    public void setTimeouts(Timeouts timeouts) {
        this.fTimeouts = timeouts;
        Timeouts times = timeouts.cloneThis();
        times.setTimeout(ACTION_PRODUCER_MAX_ACTION_TIME_NAME, timeouts.getTimeout(WHOLE_TEST_TIMEOUT_NAME));
        super.setTimeouts(times);
    }

    public Timeouts getTimeouts() {
        return this.fTimeouts;
    }

    public void startTest() throws InterruptedException {
        LOG.info((Object)("Test " + this.fScenario.getClass().getName() + " has been started."));
        try {
            this.produceAction(null);
        }
        catch (JemmyException e) {
            this.fJemmyException = e;
            LOG.info((Object)e.getMessage(), (Throwable)e);
        }
    }

    public final Object launch(Object obj) {
        this.setTimeouts(this.fTimeouts);
        int result = this.fScenario.runIt(obj);
        LOG.info((Object)(this.fScenario.getClass().getName() + " ends with " + result));
        return new Integer(result);
    }

    public void printSynopsis() {
        this.fOutput.printLine(DESCRIPTION);
    }

    public final String getDescription() {
        return "Scenario " + this.fScenario.getClass().getName();
    }

    public TestOut getOutput() {
        return this.fOutput;
    }

    public void setOutput(TestOut output) {
        this.fOutput = output;
        super.setOutput(output);
    }

    public JemmyException getJemmyException() {
        return this.fJemmyException;
    }

    static {
        Timeouts.initDefault((String)WHOLE_TEST_TIMEOUT_NAME, (long)3600000L);
    }
}

