/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.emailtest.AbstractMessageStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmailStoreHeader
extends AbstractMessageStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)EmailStoreHeader.class);
    private String fHeaderName;
    private String fPartIndex;

    public String getHeaderName() {
        return this.fHeaderName;
    }

    public void setHeaderName(String headerName) {
        this.fHeaderName = headerName;
    }

    public String getPartIndex() {
        return this.fPartIndex;
    }

    public void setPartIndex(String partIndex) {
        this.fPartIndex = partIndex;
    }

    protected String performOperation(Message message) throws MessagingException {
        Object content;
        if (StringUtils.isEmpty((String)this.getPartIndex())) {
            return EmailStoreHeader.arrayToString(message.getHeader(this.getHeaderName()));
        }
        try {
            content = message.getContent();
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing email message: ", (Throwable)e);
            throw new MessagingException("Error processing email message: " + e.getMessage());
        }
        if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            int part = ConversionUtil.convertToInt(this.getPartIndex(), 0);
            if (part >= mp.getCount()) {
                throw new StepFailedException("PartIndex too large.", this);
            }
            return EmailStoreHeader.arrayToString(mp.getBodyPart(part).getHeader(this.getHeaderName()));
        }
        throw new StepFailedException("PartIndex supplied for a non-MultiPart message.", this);
    }

    private static String arrayToString(String[] values) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            buf.append(values[i]);
            if (i >= values.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getHeaderName(), "headerName");
        this.optionalIntegerParamCheck(this.getPartIndex(), "partIndex", true);
    }
}

