/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.emailtest.AbstractMessageStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.log4j.Logger;

public class EmailStorePartFilename
extends AbstractMessageStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)EmailStorePartFilename.class);
    private String fPartIndex;

    public String getPartIndex() {
        return this.fPartIndex;
    }

    public void setPartIndex(String partIndex) {
        this.fPartIndex = partIndex;
    }

    protected String performOperation(Message message) throws MessagingException {
        Object content;
        try {
            content = message.getContent();
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing email message: ", (Throwable)e);
            throw new MessagingException("Error processing email message: " + e.getMessage());
        }
        int part = ConversionUtil.convertToInt(this.getPartIndex(), 0);
        if (content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            if (part >= mp.getCount()) {
                throw new StepFailedException("PartIndex too large.", this);
            }
            BodyPart bodyPart = mp.getBodyPart(part);
            String disp = bodyPart.getDisposition();
            if ("attachment".equals(disp)) {
                return bodyPart.getFileName();
            }
            throw new StepFailedException("No filename for inline Message Part.", this);
        }
        return this.getSimpleMessageFilename((String)content, part);
    }

    private String getSimpleMessageFilename(String content, int part) {
        String lineStr = "(^.*$)";
        String startUuencodeStr = "begin \\d\\d\\d .*";
        Pattern linePattern = Pattern.compile("(^.*$)", 8);
        Matcher matcher = linePattern.matcher(content);
        int count = 0;
        while (matcher.find()) {
            String line = matcher.group(0).trim();
            if (!line.matches("begin \\d\\d\\d .*")) continue;
            if (count == part) {
                int lastSpace = line.lastIndexOf(" ");
                return line.substring(lastSpace + 1);
            }
            ++count;
        }
        throw new StepFailedException("No matching part found.", this);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.optionalIntegerParamCheck(this.getPartIndex(), "partIndex", true);
    }
}

