/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.boundary.PackageBoundary;
import com.canoo.webtest.reporting.IResultReporter;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.StepResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;

public class PlainTextReporter
implements IResultReporter {
    public static String getBuildFailMessage(RootStepResult result) {
        StringBuffer sb = new StringBuffer();
        sb.append(PackageBoundary.versionMessage()).append("\nTest failed.");
        if (result.isError()) {
            sb.append("\nException raised: ");
            sb.append(result.getException());
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            result.getException().printStackTrace(new PrintStream(bs));
            sb.append(bs.toString());
        }
        if (result.isFailure()) {
            StepResult failedStepResult = result.getFailingTaskResult();
            sb.append("\nTest step ");
            sb.append(result.getTaskName());
            sb.append(" (").append(failedStepResult.getLocation()).append(") ");
            sb.append(failedStepResult.getTaskDescription());
            sb.append(" failed with message \"");
            sb.append(result.getException().getMessage());
            sb.append("\"");
        }
        return sb.toString();
    }

    public void generateReport(RootStepResult result) throws IOException {
        File outputFile = new File(result.getConfig().getWebTestResultDir(), "WebTestReport.txt");
        PrintWriter out = new PrintWriter(new FileOutputStream(outputFile));
        this.print(out, result);
        out.close();
    }

    protected void print(PrintWriter out, RootStepResult result) {
        out.println("Test step summary for specification: \"" + result.getWebtestName() + "\"");
        out.println(PackageBoundary.versionMessage());
        int count = 1;
        Iterator i = result.getChildren().iterator();
        while (i.hasNext()) {
            StepResult stepResult = (StepResult)i.next();
            out.println("\t" + count++ + ". " + stepResult.getTaskName());
            if (stepResult.isCompleted()) {
                out.println("\t\tDuration: " + stepResult.getDuration() + " ms");
            } else {
                out.println("\t\t==> Step was not completed!");
            }
            out.println();
        }
        if (!result.isSuccessful()) {
            out.println(PlainTextReporter.getBuildFailMessage(result));
        }
    }
}

