/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.ant.IPropertyExpansionListener;
import com.canoo.webtest.ant.TestStepSequence;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.MimeMap;
import com.canoo.webtest.engine.NOPBuildListener;
import com.canoo.webtest.engine.WebClientContext;
import com.canoo.webtest.reporting.IStepResultListener;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.StepResult;
import com.canoo.webtest.steps.HtmlParserMessage;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Task;

public class StepExecutionListener
extends NOPBuildListener
implements IStepResultListener,
IPropertyExpansionListener {
    private static final Logger LOG = Logger.getLogger((Class)StepExecutionListener.class);
    private StepResult fCurrentResult;
    private final HtmlParserMessage.MessageCollector fHtmlParserMessageCollector;
    private final Context fContext;
    private Page fPreviousCurrentResponse;
    private WebClientContext.StoredResponses fPreviousResponses;
    private boolean domChangedInLastPage = false;
    private int resultIndex = 0;
    private final DomChangeListener domChangeListener = new DomChangeListener(){

        public void nodeAdded(DomChangeEvent event) {
            StepExecutionListener.this.domChangedInLastPage = true;
        }

        public void nodeDeleted(DomChangeEvent event) {
            StepExecutionListener.this.domChangedInLastPage = true;
        }
    };
    private RootStepResult fRootResult;
    private boolean fIgnoreCurrentTasks;

    public StepExecutionListener(Context context) {
        this.fContext = context;
        this.fHtmlParserMessageCollector = context.getConfig().isShowHtmlParserOutput() ? (HtmlParserMessage.MessageCollector)context.getWebClient().getHTMLParserListener() : null;
    }

    protected List getLastHtmlParserMessages() {
        if (this.fHtmlParserMessageCollector == null) {
            return new ArrayList();
        }
        return this.fHtmlParserMessageCollector.popAll();
    }

    public RootStepResult getRootResult() {
        return this.fRootResult;
    }

    protected boolean isInteresting(Task task) {
        if (this.fIgnoreCurrentTasks) {
            LOG.debug((Object)("currently ignoring: " + task));
            return false;
        }
        if (this.isToIgnore(task)) {
            LOG.debug((Object)("toIgnore: " + task));
            this.fIgnoreCurrentTasks = true;
            return false;
        }
        return !"sequential".equals(task.getTaskName());
    }

    protected boolean isToIgnore(Task task) {
        return "antlib".equals(task.getTaskName());
    }

    public void propertiesExpanded(String originalValue, String expanded) {
        this.fCurrentResult.propertiesExpanded(originalValue, expanded);
    }

    public void stepResults(Map results) {
        this.fCurrentResult.addStepResults(results);
    }

    public void taskFinished(BuildEvent event) {
        Task task = event.getTask();
        LOG.trace((Object)("taskFinished: " + task.getTaskName()), event.getException());
        if (this.isToIgnore(task)) {
            this.fIgnoreCurrentTasks = false;
            return;
        }
        if (!this.isInteresting(task)) {
            return;
        }
        if (this.fCurrentResult == null) {
            throw new IllegalStateException("No current result");
        }
        List liHtmlParserMessages = this.getLastHtmlParserMessages();
        if (!this.fCurrentResult.isSuccessful()) {
            Throwable exception = event.getException();
            this.fRootResult.setLastFailingTaskResult(this.fCurrentResult, exception);
        }
        this.fCurrentResult.taskFinished(task, event.getException(), liHtmlParserMessages);
        this.saveCurrentResponseIfNeeded(event);
        if (event.getException() != null && this.fPreviousResponses != null) {
            this.fContext.restoreResponses(this.fPreviousResponses);
            this.fPreviousResponses = null;
        }
        this.fPreviousCurrentResponse = this.fContext.getCurrentResponse();
        this.fCurrentResult = this.fCurrentResult.getParent();
    }

    /*
     * WARNING - void declaration
     */
    private void saveCurrentResponseIfNeeded(BuildEvent event) {
        void var3_8;
        File file;
        if (!this.isSaveResponse()) {
            return;
        }
        String savePrefix = this.getSavePrefix();
        if (this.isNewResponse(event)) {
            WebResponse resp;
            if (this.isExceptionWithResponse(event)) {
                Throwable cause = event.getException().getCause();
                resp = cause instanceof FailingHttpStatusCodeException ? ((FailingHttpStatusCodeException)cause).getResponse() : ((ScriptException)cause).getPage().getWebResponse();
            } else {
                resp = this.fContext.getCurrentResponse().getWebResponse();
                if (this.fContext.getCurrentResponse() instanceof HtmlPage) {
                    HtmlPage page = (HtmlPage)this.fContext.getCurrentResponse();
                    page.addDomChangeListener(this.domChangeListener);
                }
            }
            file = this.getResponseFile(resp, savePrefix, this.fCurrentResult.getTaskName());
            ContextHelper.writeResponseFile(resp, file);
        } else if (this.domChangedInLastPage && this.fContext.getCurrentResponse() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.fContext.getCurrentResponse();
            file = this.getResponseFile("html", savePrefix, this.fCurrentResult.getTaskName());
            try {
                FileUtils.writeStringToFile((File)file, (String)page.asXml());
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to dump current page state to file", (Throwable)e);
            }
        } else {
            return;
        }
        this.fCurrentResult.getAttributes().put("resultFilename", var3_8.getName());
        this.domChangedInLastPage = false;
    }

    private String getSavePrefix() {
        String prefix = this.fCurrentResult.getAttribute("save");
        if (!StringUtils.isEmpty((String)prefix)) {
            return prefix;
        }
        prefix = this.fCurrentResult.getAttribute("savePrefix");
        return StringUtils.defaultIfEmpty((String)prefix, (String)this.fContext.getConfig().getSavePrefix());
    }

    File getResponseFile(String fileExtension, String fileNamePrefix, String fileNameSuffix) {
        int namespaceIndex = fileNameSuffix.indexOf(":");
        File resultDir = this.fContext.getConfig().getWebTestResultDir();
        String prefix = StringUtils.leftPad((String)String.valueOf(++this.resultIndex), (int)3, (char)'0');
        String filename = prefix + "_" + fileNamePrefix + "_" + fileNameSuffix.substring(namespaceIndex == -1 ? 0 : namespaceIndex + 1) + "." + fileExtension;
        return new File(resultDir, filename);
    }

    File getResponseFile(WebResponse response, String fileNamePrefix, String fileNameSuffix) {
        String contentType = response.getContentType();
        contentType = MimeMap.adjustMimeTypeIfNeeded(contentType, response.getUrl().toString());
        String extension = MimeMap.getExtension(contentType);
        return this.getResponseFile(extension, fileNamePrefix, fileNameSuffix);
    }

    private boolean isExceptionWithResponse(BuildEvent event) {
        if (event.getException() == null) {
            return false;
        }
        Throwable cause = event.getException().getCause();
        if (cause instanceof FailingHttpStatusCodeException) {
            return true;
        }
        if (cause instanceof ScriptException) {
            ScriptException se = (ScriptException)cause;
            return se.getPage() != null;
        }
        return false;
    }

    private boolean isNewResponse(BuildEvent event) {
        LOG.debug((Object)("fPreviousCurrentResponse: " + this.fPreviousCurrentResponse));
        LOG.debug((Object)("fContext.getCurrentResponse(): " + this.fContext.getCurrentResponse()));
        boolean br = this.fPreviousCurrentResponse != this.fContext.getCurrentResponse();
        LOG.debug((Object)("isWorthSaving: " + br + ", " + this.isExceptionWithResponse(event)));
        return this.fContext.getCurrentResponse() != null && this.fPreviousCurrentResponse != this.fContext.getCurrentResponse() || this.isExceptionWithResponse(event);
    }

    private boolean isSaveResponse() {
        String stepSave = this.fCurrentResult.getAttribute("save");
        if (!StringUtils.isEmpty((String)stepSave)) {
            return true;
        }
        String stepSaveResponse = this.fCurrentResult.getAttribute("saveresponse");
        if (!StringUtils.isEmpty((String)stepSaveResponse)) {
            return ConversionUtil.convertToBoolean(stepSaveResponse, false);
        }
        return this.fContext.getConfig().isSaveResponse();
    }

    public void taskStarted(BuildEvent event) {
        Task task = event.getTask();
        if (!this.isInteresting(task)) {
            return;
        }
        StepResult result = new StepResult(task);
        if (this.fCurrentResult != null) {
            this.fCurrentResult.addChild(result);
            this.fCurrentResult = result;
        } else {
            this.fRootResult = new RootStepResult((TestStepSequence)task);
            this.fCurrentResult = this.fRootResult;
        }
        this.fPreviousCurrentResponse = this.fContext.getCurrentResponse();
        this.fPreviousResponses = this.fContext.getResponses();
    }
}

