/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;

public class StepResult {
    private static final Logger LOG = Logger.getLogger((Class)StepResult.class);
    private final Map fAttributes = new TreeMap();
    private final List fChildren = new ArrayList();
    private Date fEndDate;
    private List fHtmlParserMessages = Collections.EMPTY_LIST;
    private Location fLocation;
    private StepResult fParent;
    private final Date fStartDate = new Date();
    private boolean fSuccessfull;
    private String fTaskDescription;
    private final String fTaskName;

    private static String getName(Task task) {
        String taskName = task.getTaskName();
        if (taskName == null) {
            return task.getTaskType() + " " + ClassUtils.getShortClassName(task.getClass());
        }
        return taskName;
    }

    protected StepResult(RuntimeConfigurable taskWrapper) {
        this(taskWrapper.getElementTag());
        this.fAttributes.putAll(taskWrapper.getAttributeMap());
        this.fTaskDescription = (String)this.fAttributes.get("description");
        LOG.debug((Object)("Constructing result for non executed task: " + this.getTaskName()));
        this.retrieveNestedText(taskWrapper);
        if ("table".equals(taskWrapper.getElementTag())) {
            this.fEndDate = this.fStartDate;
            this.fSuccessfull = true;
        }
        this.addLostChildren(IteratorUtils.asIterator((Enumeration)taskWrapper.getChildren()));
    }

    public StepResult(String taskName) {
        this.fTaskName = taskName;
    }

    protected void retrieveNestedText(RuntimeConfigurable taskWrapper) {
        LOG.trace((Object)"In retrieveNestedText");
        String nestedText = taskWrapper.getText().toString().trim();
        IntrospectionHelper ih = IntrospectionHelper.getHelper(taskWrapper.getClass());
        if (nestedText.length() > 0 && ih.supportsCharacters()) {
            LOG.debug((Object)(taskWrapper.getElementTag() + " supports text: " + ih.getAddTextMethod()));
            this.fAttributes.put("nested text", nestedText);
        }
    }

    StepResult(Task task) {
        this(StepResult.getName(task));
        this.retrieveNestedText(task.getRuntimeConfigurableWrapper());
        Hashtable attributeMap = task.getRuntimeConfigurableWrapper().getAttributeMap();
        Iterator iterator = attributeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.fAttributes.put(entry.getKey(), task.getProject().replaceProperties((String)entry.getValue()));
        }
        this.fTaskDescription = (String)this.fAttributes.get("description");
        this.fAttributes.remove("description");
        this.fLocation = task.getLocation();
    }

    void propertiesExpanded(String originalValue, String expanded) {
        Iterator iter = this.fAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String unexpandedValue = (String)entry.getValue();
            if (!originalValue.equals(unexpandedValue)) continue;
            LOG.debug((Object)("Replacing value with expanded value: " + expanded));
            entry.setValue(expanded);
        }
    }

    public void addChild(StepResult result) {
        if (result == null) {
            throw new IllegalArgumentException("child can't be null");
        }
        result.fParent = this;
        this.fChildren.add(result);
    }

    protected void addLostChildren(Iterator iter) {
        while (iter.hasNext()) {
            RuntimeConfigurable child = (RuntimeConfigurable)iter.next();
            this.addChild(new StepResult(child));
        }
    }

    protected void addNotExecutedChildren(Task task) {
        List children;
        RuntimeConfigurable taskWrapper = task.getRuntimeConfigurableWrapper();
        if (taskWrapper == null) {
            LOG.debug((Object)("No wrapper found for task " + task + ", skipping lost children search"));
            return;
        }
        int iNbKnownChildren = this.getChildren().size();
        if (iNbKnownChildren < (children = EnumerationUtils.toList((Enumeration)taskWrapper.getChildren())).size()) {
            this.addLostChildren(children.listIterator(iNbKnownChildren));
        }
    }

    public Map getAttributes() {
        return this.fAttributes;
    }

    public List getChildren() {
        return this.fChildren;
    }

    public long getDuration() {
        if (this.isCompleted()) {
            return this.getEndDate().getTime() - this.getStartDate().getTime();
        }
        return -1L;
    }

    public Date getEndDate() {
        return this.fEndDate;
    }

    public List getHtmlParserMessages() {
        return this.fHtmlParserMessages;
    }

    public Location getLocation() {
        return this.fLocation;
    }

    StepResult getParent() {
        return this.fParent;
    }

    public Date getStartDate() {
        return this.fStartDate;
    }

    public String getTaskDescription() {
        return this.fTaskDescription;
    }

    public String getTaskName() {
        return this.fTaskName;
    }

    public boolean isCompleted() {
        return this.getEndDate() != null;
    }

    public boolean isSuccessful() {
        return this.fSuccessfull;
    }

    void taskFinished(Task task, Throwable throwable, List liHtmlParserMessages) {
        this.fEndDate = new Date();
        this.fSuccessfull = throwable == null;
        this.fHtmlParserMessages = liHtmlParserMessages;
        this.addNotExecutedChildren(task);
    }

    void addStepResults(Map results) {
        this.fAttributes.putAll(results);
    }

    String getAttribute(String key) {
        if (key == null) {
            return null;
        }
        Iterator iter = this.fAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return null;
    }
}

