/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.security;

import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.security.ConnectionInitializationException;
import com.canoo.webtest.security.SunJsseBaseConnectionInitializer;

public class SunJsseClientAuthConnectionInitializer
extends SunJsseBaseConnectionInitializer {
    protected static final String SECURITY_PROVIDER = "SunX509";
    protected static final String KEYSTORE_TYPE = "JKS";
    protected static final String SSL_TYPE = "TLS";

    protected void logProtocolConfiguration(Configuration config) {
        super.logProtocolConfiguration(config);
        SunJsseClientAuthConnectionInitializer.logProperty(config, "webtest.keystore.file");
        SunJsseClientAuthConnectionInitializer.logProperty(config, "webtest.keystore.passphrase");
        SunJsseClientAuthConnectionInitializer.logProperty(config, "webtest.keystore.alias");
    }

    protected void installTrustAndKeyManager(Configuration config) throws ConnectionInitializationException {
        SunJsseClientAuthConnectionInitializer.setSystemProperty("javax.net.ssl.keyStore", SunJsseClientAuthConnectionInitializer.getExternalProperty(config, "webtest.keystore.file"));
        SunJsseClientAuthConnectionInitializer.setSystemProperty("javax.net.ssl.keyStorePassword", SunJsseClientAuthConnectionInitializer.getExternalProperty(config, "webtest.keystore.passphrase"));
        SunJsseClientAuthConnectionInitializer.setSystemProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

