/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.form.AbstractSetNamedFieldStep;
import com.canoo.webtest.steps.request.TargetHelper;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SetSelectField
extends AbstractSetNamedFieldStep {
    private static final Logger LOG = Logger.getLogger((Class)SetSelectField.class);
    static final String MESSAGE_MISSING_OPTION_IDENTIFIER = "Either \"value\", \"text\" or \"optionIndex\" is required to identify option in select identified by \"htmlId\" or \"xpath\"!";
    static final String AT_MOST_ONE_VALUE_TEXT_OPTIONINDEX = "At most one of \"value\", \"text\" or \"optionIndex\" can be set!";
    private boolean fIsMultiSelect;
    private boolean fIsRegex;
    private String fMultiSelect;
    private String fRegex;
    private String fText;
    private String fOptionIndex;
    private String fUserName;
    private String fPassword;
    private String fSavePrefix;
    private String fSaveResponse;
    private final TargetHelper fTargetHelper = new TargetHelper(this);

    public boolean isRegex() {
        return this.fIsRegex;
    }

    public boolean isMultiSelect() {
        return this.fIsMultiSelect;
    }

    public void setMultiselect(String multiSelect) {
        this.fMultiSelect = multiSelect;
    }

    public String getMultiselect() {
        return this.fMultiSelect;
    }

    public void setRegex(String regex) {
        this.fRegex = regex;
    }

    public String getRegex() {
        return this.fRegex;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    public void setOptionIndex(String index) {
        this.fOptionIndex = index;
    }

    public String getOptionIndex() {
        return this.fOptionIndex;
    }

    public void setUserName(String userName) {
        this.fUserName = userName;
    }

    public String getUserName() {
        return this.fUserName;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setSavePrefix(String prefix) {
        this.fSavePrefix = prefix;
    }

    public String getSavePrefix() {
        return this.fSavePrefix;
    }

    public void setSaveResponse(String response) {
        this.fSaveResponse = response;
    }

    public String getSaveResponse() {
        return this.fSaveResponse;
    }

    public String getSave() {
        return null;
    }

    public void setIndex(String index) {
        LOG.warn((Object)"setIndex is deprecated - use setOptionIndex instead");
        this.setOptionIndex(index);
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    protected HtmlForm findForm() {
        return FormUtil.findFormForField(this.getContext(), this.getFormName(), "select", null, this.getName(), this);
    }

    protected List findFields(HtmlForm form) {
        return form.getSelectsByName(this.getName());
    }

    /*
     * WARNING - void declaration
     */
    protected void setField(HtmlElement elt) {
        void var3_2;
        void var2_3;
        HtmlSelect select;
        HtmlOption option;
        if (elt instanceof HtmlOption) {
            option = (HtmlOption)elt;
            select = (HtmlSelect)option.getEnclosingElement("select");
        } else if (elt instanceof HtmlSelect) {
            select = (HtmlSelect)elt;
            if (this.getText() == null && this.getOptionIndex() == null && this.getValue() == null) {
                throw new StepExecutionException(MESSAGE_MISSING_OPTION_IDENTIFIER, this);
            }
            option = this.findMatchingOption(select);
        } else {
            throw new StepFailedException("Found " + elt.getTagName() + " when looking for select", this);
        }
        if (var2_3.isMultipleSelectEnabled() && !this.fIsMultiSelect) {
            SetSelectField.deselectOtherOptions((HtmlSelect)var2_3, (HtmlOption)var3_2);
        }
        this.updateOption((HtmlSelect)var2_3, (HtmlOption)var3_2);
    }

    void updateOption(HtmlSelect select, HtmlOption option) {
        if (option == null) {
            throw new StepFailedException("No option found matching criteria in select " + select);
        }
        this.fTargetHelper.setUsername(this.getUserName());
        this.fTargetHelper.setPassword(this.getPassword());
        this.maybeTarget((Page)option.getPage(), select, option);
    }

    protected void maybeTarget(Page page, HtmlSelect select, HtmlOption option) {
        LOG.debug((Object)("Selected option: " + option));
        select.setSelectedAttribute(option, true);
    }

    private static void deselectOtherOptions(HtmlSelect select, HtmlOption option) {
        Iterator iter = select.getOptions().iterator();
        while (iter.hasNext()) {
            HtmlOption curOpt = (HtmlOption)iter.next();
            if (curOpt == option || !curOpt.isSelected()) continue;
            curOpt.setSelected(false);
        }
    }

    HtmlOption findMatchingOption(HtmlSelect select) throws StepExecutionException {
        LOG.debug((Object)("Searching for the right option in " + select));
        if (this.getValue() != null) {
            LOG.debug((Object)("Searching option with value: " + this.getValue()));
            try {
                return select.getOptionByValue(this.getValue());
            }
            catch (ElementNotFoundException enfe) {
                LOG.debug((Object)enfe.getMessage());
                return null;
            }
        }
        if (this.getText() != null) {
            LOG.debug((Object)("Searching option with text: " + this.getText()));
            return this.getOptionForText(select, this.getText());
        }
        LOG.debug((Object)("Searching option with index: " + this.getOptionIndex()));
        return (HtmlOption)select.getOptions().get(ConversionUtil.convertToInt(this.getOptionIndex(), 0));
    }

    private HtmlOption getOptionForText(HtmlSelect select, String text) {
        IStringVerifier verifier = SetSelectField.getVerifier(this.fIsRegex);
        Iterator iter = select.getOptions().iterator();
        while (iter.hasNext()) {
            HtmlOption option = (HtmlOption)iter.next();
            LOG.debug((Object)("Examining option: " + option));
            if (!verifier.verifyStrings(text, option.asText())) continue;
            LOG.debug((Object)("Found option by text: " + option));
            return option;
        }
        throw new StepFailedException("No option element found with text \"" + text + "\"", this);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        int iNbNotNull = 0;
        if (!this.isValueNull()) {
            ++iNbNotNull;
        }
        if (this.getText() != null) {
            ++iNbNotNull;
        }
        if (this.getOptionIndex() != null) {
            this.integerParamCheck(this.getOptionIndex(), "optionIndex", false);
            ++iNbNotNull;
        }
        boolean bXPathOrId = this.getXpath() != null || this.getHtmlId() != null;
        this.paramCheck(iNbNotNull > 1, AT_MOST_ONE_VALUE_TEXT_OPTIONINDEX);
        this.paramCheck(!bXPathOrId && iNbNotNull == 0, "One of \"xpath\", \"htmlId\", \"value\", \"text\" or \"optionIndex\" is required!");
        this.fIsMultiSelect = ConversionUtil.convertToBoolean(this.getMultiselect(), false);
        this.fIsRegex = ConversionUtil.convertToBoolean(this.getRegex(), false);
    }
}

