/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.request.AbstractIdOrLabelTarget;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;

public class ClickLink
extends AbstractIdOrLabelTarget {
    private static final Logger LOG = Logger.getLogger((Class)ClickLink.class);
    private String fHref;

    public String getHref() {
        return this.fHref;
    }

    public void setHref(String href) {
        this.fHref = href;
    }

    protected Page findTarget() throws JaxenException, IOException {
        HtmlPage currentResp = this.getContext().getCurrentHtmlResponse(this);
        HtmlAnchor link = (HtmlAnchor)this.findClickableElement(currentResp);
        if (link == null) {
            StepFailedException e = new StepFailedException("Link not found in page " + currentResp.getWebResponse().getUrl(), this);
            StringBuffer sb = new StringBuffer();
            Iterator iter = currentResp.getAnchors().iterator();
            while (iter.hasNext()) {
                HtmlAnchor webLink = (HtmlAnchor)iter.next();
                sb.append("- label \"").append(webLink.asText());
                sb.append("\" with url \"").append(webLink.getHrefAttribute());
                sb.append("\" and id \"").append(webLink.getIdAttribute());
                sb.append("\"\n");
            }
            e.addDetail("available links", sb.toString());
            throw e;
        }
        LOG.debug((Object)("Clicking on link with href: " + link.getHrefAttribute()));
        return link.click();
    }

    protected String getLogMessageForTarget() {
        return "by clickLink";
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        int count = 0;
        if (this.getXpath() != null) {
            ++count;
        }
        if (this.getHtmlId() != null) {
            ++count;
        }
        if (this.getHref() != null || this.getLabel() != null) {
            ++count;
        }
        this.paramCheck(count == 0, "\"htmlId\" or \"xpath\" or \"label\" or \"href\" must be set!");
        this.paramCheck(count > 1, "\"htmlId\", \"xpath\" and \"label\" or \"href\" can't be combined!");
    }

    protected HtmlAnchor locateWebLink(HtmlPage page) {
        return (HtmlAnchor)this.findClickableElement(page);
    }

    protected ClickableElement findClickableElementByAttribute(HtmlPage page) {
        HtmlAnchor link = this.locateTextLink(page);
        if (link != null) {
            return link;
        }
        return ClickLink.getLinkWithImageText(page, this.getLabel());
    }

    protected static HtmlAnchor getLinkWithImageText(HtmlPage htmlPage, String text) {
        List li = htmlPage.getDocumentHtmlElement().getHtmlElementsByAttribute("img", "alt", text);
        LOG.debug((Object)("Found " + li.size() + " images with alt=\"" + text + "\""));
        Iterator iter = li.iterator();
        while (iter.hasNext()) {
            HtmlElement elt = (HtmlElement)iter.next();
            HtmlAnchor link = (HtmlAnchor)ClickLink.findParent("a", elt);
            if (link == null) continue;
            return link;
        }
        return null;
    }

    private static HtmlElement findParent(String tagName, HtmlElement elt) {
        HtmlElement parent = (HtmlElement)elt.getParentDomNode();
        while (parent != null) {
            if (tagName.equals(parent.getTagName())) {
                return parent;
            }
            DomNode o = parent.getParentDomNode();
            parent = o instanceof HtmlElement ? (HtmlElement)o : null;
        }
        return null;
    }

    protected HtmlAnchor locateTextLink(HtmlPage currentResponse) {
        Iterator iter = currentResponse.getAnchors().iterator();
        while (iter.hasNext()) {
            HtmlAnchor curLink = (HtmlAnchor)iter.next();
            if (!this.isMatching(curLink)) continue;
            return curLink;
        }
        return null;
    }

    protected boolean isMatching(HtmlAnchor link) {
        boolean bRep = true;
        if (this.getLabel() != null) {
            bRep = link.asText().indexOf(this.getLabel()) >= 0;
        }
        LOG.debug((Object)("labelFound = " + bRep + " in " + link.asText()));
        if (this.getHref() == null) {
            return bRep;
        }
        boolean bHrefFound = link.getHrefAttribute().indexOf(this.getHref()) >= 0;
        LOG.debug((Object)("hrefFound = " + bHrefFound + " in " + link.getHrefAttribute()));
        return bRep && bHrefFound;
    }

    ClickableElement checkFoundElement(HtmlElement elt) throws StepFailedException {
        if (elt instanceof HtmlAnchor) {
            return (ClickableElement)elt;
        }
        throw new StepFailedException("Selected element is a " + elt.getTagName() + " tag and not a link", this);
    }

    public void addText(String text) {
        this.setLabel(this.getProject().replaceProperties(text));
    }
}

