/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SelectWindow
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)SelectWindow.class);
    private String fName;
    private String fIndex;
    private String fTitle;

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String newTitle) {
        this.fTitle = newTitle;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String newName) {
        this.fName = newName;
    }

    public void setIndex(String newIndex) {
        this.fIndex = newIndex;
    }

    public String getIndex() {
        return this.fIndex;
    }

    public void doExecute() throws Exception {
        LOG.debug((Object)("Selecting window " + this.getName()));
        Context context = this.getContext();
        WebClient webClient = context.getWebClient();
        WebWindow window = this.findTopLevelWindow(webClient);
        if (window == null) {
            StepFailedException sfe = new StepFailedException("No window found");
            sfe.addDetail("available windows", SelectWindow.getAvailableWindowsMessage(webClient));
            throw sfe;
        }
        context.saveResponseAsCurrent(window.getEnclosedPage());
    }

    WebWindow findTopLevelWindow(WebClient webClient) {
        WebWindow result = this.getName() != null ? this.findTopLevelWindowByName(webClient) : (this.getTitle() != null ? this.findTopLevelWindowByTitle(webClient) : this.findTopLevelWindowByIndex(webClient));
        return result;
    }

    WebWindow findTopLevelWindowByName(WebClient webClient) {
        Iterator iter = webClient.getWebWindows().iterator();
        while (iter.hasNext()) {
            WebWindow window = (WebWindow)iter.next();
            if (!(window instanceof TopLevelWindow) || !window.getName().equals(this.getName())) continue;
            return window;
        }
        return null;
    }

    WebWindow findTopLevelWindowByTitle(WebClient webClient) {
        Iterator iter = webClient.getWebWindows().iterator();
        while (iter.hasNext()) {
            Page containedPage;
            WebWindow window = (WebWindow)iter.next();
            if (!(window instanceof TopLevelWindow) || !((containedPage = window.getEnclosedPage()) instanceof HtmlPage) || !this.getTitle().equals(((HtmlPage)containedPage).getTitleText())) continue;
            return window;
        }
        return null;
    }

    WebWindow findTopLevelWindowByIndex(WebClient webClient) {
        int count = 0;
        int index = ConversionUtil.convertToInt(this.getIndex(), 0);
        Iterator iter = webClient.getWebWindows().iterator();
        while (iter.hasNext()) {
            WebWindow window = (WebWindow)iter.next();
            if (!(window instanceof TopLevelWindow) || count++ != index) continue;
            return window;
        }
        return null;
    }

    static String getAvailableWindowsMessage(WebClient webClient) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        Iterator iter = webClient.getWebWindows().iterator();
        while (iter.hasNext()) {
            WebWindow curWindow = (WebWindow)iter.next();
            if (!(curWindow instanceof TopLevelWindow)) continue;
            Page page = curWindow.getEnclosedPage();
            if (i > 0) {
                sb.append("\n");
            }
            sb.append("index: " + i + ", name: >" + curWindow.getName() + "<");
            if (page instanceof HtmlPage) {
                sb.append(", title: >" + ((HtmlPage)page).getTitleText() + "<");
            } else {
                sb.append(", " + page.getWebResponse().getContentType());
            }
            sb.append(", url: " + page.getWebResponse().getUrl());
            ++i;
        }
        return sb.toString();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        this.paramCheck(this.getName() == null && this.getTitle() == null && StringUtils.isEmpty((String)this.getIndex()), "Required parameter 'name', 'title' or 'index' must be set!");
        this.optionalIntegerParamCheck(this.getIndex(), "index", true);
    }
}

