/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.boundary.HttpClientBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.MapUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;

public class StoreCookie
extends BaseStoreStep {
    private static final Logger LOG = Logger.getLogger((Class)StoreCookie.class);
    private String fCookieName;
    private String fCookieValue;

    public void setName(String name) {
        this.fCookieName = name;
    }

    public String getName() {
        return this.fCookieName;
    }

    public void doExecute() {
        Cookie[] cookies = StoreCookie.getCookies(this.getContext());
        LOG.debug((Object)("Found " + cookies.length + " cookie(s)"));
        if (cookies.length == 0) {
            throw new StepFailedException("No cookies set!", this);
        }
        Cookie cookie = this.findCookie(cookies);
        if (cookie == null) {
            throw new StepFailedException("Cookie \"" + this.fCookieName + "\" not set!", this);
        }
        this.storeProperty(cookie.getValue(), this.getName());
        this.fCookieValue = cookie.getValue();
    }

    protected void addComputedParameters(Map map) {
        MapUtil.putIfNotNull(map, "-> cookie value", this.fCookieValue);
    }

    Cookie findCookie(Cookie[] cookies) {
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(this.fCookieName)) continue;
            return cookie;
        }
        return null;
    }

    public static Cookie[] getCookies(Context context) {
        URL url = context.getCurrentResponse().getWebResponse().getUrl();
        WebClient webClient = context.getWebClient();
        HttpState stateForUrl = webClient.getWebConnection().getState();
        return HttpClientBoundary.getCookiesFromState(stateForUrl, url);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fCookieName, "name");
        this.nullResponseCheck();
    }
}

