/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.StoreElementAttribute;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.steps.form.AbstractSetFieldStep;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractVerifyFormStep
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)AbstractVerifyFormStep.class);
    private String fName;
    private String fValue;
    private String fFormName;
    private String fFieldIndex;
    private String fHtmlId;
    private String fXPath;

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setFormName(String formName) {
        this.fFormName = formName;
    }

    public String getFormName() {
        return this.fFormName;
    }

    public void setFieldIndex(String index) {
        this.fFieldIndex = index;
    }

    public String getFieldIndex() {
        return this.fFieldIndex;
    }

    public void setXpath(String xpath) {
        this.fXPath = xpath;
    }

    public String getXpath() {
        return this.fXPath;
    }

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void doExecute() throws IOException {
        if (this.getName() != null) {
            HtmlForm form = this.findForm();
            if (form == null) {
                throw new StepFailedException("No suitable form found having field named \"" + this.getName() + "\"", this);
            }
            this.verifyField(AbstractSetFieldStep.selectField(this.findFields(form), this.getFieldIndex(), this));
        } else {
            this.verifyField(StoreElementAttribute.findElement(this.getContext().getCurrentResponse(), this.getHtmlId(), this.getXpath(), LOG, this));
        }
    }

    protected abstract HtmlForm findForm();

    protected abstract List findFields(HtmlForm var1);

    protected abstract void verifyField(HtmlElement var1) throws IOException;

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        int count = 0;
        if (this.getXpath() != null) {
            ++count;
        }
        if (this.getName() != null) {
            ++count;
        }
        if (this.getHtmlId() != null) {
            ++count;
        }
        this.paramCheck(count == 0, "One of 'forLabel', 'htmlId', 'name', or 'xpath' must be set!");
        this.paramCheck(count > 1, "Only one of 'forLabel', 'htmlId', 'name', and 'xpath' should be set!");
        if (this.getName() == null) {
            this.paramCheck(this.getFieldIndex() != null, "The attribute 'fieldIndex' is only valid with the attribute 'name'.");
        } else {
            this.optionalIntegerParamCheck(this.getFieldIndex(), "fieldIndex", false);
        }
    }

    protected boolean isValueNull() {
        return this.getValue() == null;
    }
}

