/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.interfaces.IStepWithTableLocator;
import com.canoo.webtest.interfaces.ITableLocator;
import com.canoo.webtest.steps.locator.TableLocator;
import com.canoo.webtest.steps.locator.TableNotFoundException;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import java.io.IOException;
import org.xml.sax.SAXException;

public class VerifyText
extends AbstractVerifyTextStep
implements IStepWithTableLocator {
    private ITableLocator fTableLocator;

    public void addText(String text) {
        if (this.getText() == null) {
            this.setText(this.getProject().replaceProperties(text));
        }
    }

    public void addTable(TableLocator tableLocator) {
        this.addTableInternal(tableLocator);
    }

    public void addTableInternal(ITableLocator tableLocator) {
        this.fTableLocator = tableLocator;
    }

    public void doExecute() throws Exception {
        if (!this.isExpectedStringPresent()) {
            throw new StepFailedException(this.getStepLabel() + ": " + this.getFailedMessage(), this);
        }
    }

    protected String getFailedMessage() {
        return "Text not found in page. Expected <" + this.getText() + ">";
    }

    protected boolean isExpectedStringPresent(Context context) throws SAXException, IOException {
        return this.isExpectedStringPresent();
    }

    protected boolean isExpectedStringPresent() throws SAXException, IOException {
        Context context = this.getContext();
        try {
            String text = this.getTableLocator() == null ? context.getCurrentResponse().getWebResponse().getContentAsString() : this.getTableLocator().locateText(context, this);
            if (this.isRegex()) {
                return this.verifyText(text);
            }
            return text.indexOf(this.getText()) > -1;
        }
        catch (TableNotFoundException tnf) {
            throw new StepFailedException("Cannot find table: " + tnf.toString(), this);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new StepFailedException("Cannot find cell with supplied index in table", this);
        }
    }

    public ITableLocator getTableLocator() {
        return this.fTableLocator;
    }
}

