/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.util;

import com.canoo.webtest.boundary.StreamBoundary;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger LOG = Logger.getLogger((Class)FileUtil.class);

    public static String readFileToString(File file, Step step) {
        String canonicalPath = null;
        String result = null;
        FileInputStream inputStream = null;
        try {
            canonicalPath = file.getCanonicalPath();
            inputStream = new FileInputStream(file);
            result = IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            try {
                throw new StepExecutionException("Could not find/read \"" + canonicalPath + "\".", step);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    public static byte[] readFileToByteArray(File file, Step step) {
        String canonicalPath = null;
        byte[] result = null;
        FileInputStream inputStream = null;
        try {
            canonicalPath = file.getCanonicalPath();
            inputStream = new FileInputStream(file);
            result = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            try {
                throw new StepExecutionException("Could not find/read \"" + canonicalPath + "\".", step);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    public static void writeStringToFile(File file, String content, Step step) {
        String canonicalPath = null;
        FileOutputStream outputStream = null;
        try {
            canonicalPath = file.getCanonicalPath();
            outputStream = new FileOutputStream(file);
            IOUtils.write((String)content, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new StepExecutionException("Could not find/write \"" + canonicalPath + "\".", step);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void writeResponseStreamToFile(WebResponse inputResponse, File destfile, Step step) {
        String canonicalPath = null;
        FileOutputStream outputStream = null;
        try {
            canonicalPath = destfile.getCanonicalPath();
            outputStream = new FileOutputStream(destfile);
            IOUtils.copy((InputStream)inputResponse.getContentAsStream(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new StepExecutionException("Could not find/write \"" + canonicalPath + "\".", step);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void prepareDirs(File file) {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            FileUtil.prepareDirs(file.getParentFile());
            file.getParentFile().mkdirs();
        }
    }

    public static Object tryReadObjectFromFile(File file, Step step) {
        Object object;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        String message = "finding";
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            message = "reading from";
            object = StreamBoundary.tryReadObject(ois, step);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new StepExecutionException("Error " + message + " file: " + e.getMessage(), step);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)fis);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryWriteObjectToFile(File file, Object object, Step step) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        String message = "creating";
        boolean success = false;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            message = "filling";
            oos.writeObject(object);
            success = true;
        }
        catch (IOException e) {
            block4: {
                try {
                    LOG.error((Object)("Error during write: " + e.getMessage()), (Throwable)e);
                    if (step == null) break block4;
                    throw new StepExecutionException("Error " + message + " file: " + e.getMessage(), step);
                }
                catch (Throwable throwable) {
                    StreamBoundary.closeOutputStream(oos);
                    StreamBoundary.closeOutputStream(fos);
                    throw throwable;
                }
            }
            StreamBoundary.closeOutputStream(oos);
            StreamBoundary.closeOutputStream(fos);
        }
        StreamBoundary.closeOutputStream(oos);
        StreamBoundary.closeOutputStream(fos);
        return success;
    }

    public static File tryCreateTempFile(String prefix, String suffix, Step step) {
        File tmpFile;
        try {
            tmpFile = File.createTempFile(prefix, suffix);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new StepExecutionException("Error creating temporary file " + e.getMessage(), step);
        }
        tmpFile.deleteOnExit();
        return tmpFile;
    }
}

