/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.DumpController;

public class Dumper {
    private static final String tabIncrease = "  ";

    public static void printDTD(PrintWriter writer) {
        Dumper.printDTD(writer, "");
    }

    public static void printDTD(PrintStream writer) {
        Dumper.printDTD(new PrintWriter(writer));
    }

    public static void printDTD(String fileName) throws FileNotFoundException {
        Dumper.printDTD(new PrintWriter(new FileOutputStream(fileName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpComponent(Component comp, PrintWriter writer, DumpController listener) {
        QueueTool qt = new QueueTool();
        Component[] comps = comp != null ? new Component[]{comp} : Frame.getFrames();
        try {
            qt.lock();
            Dumper.printHeader(writer);
            Dumper.dumpSome("dump", comps, writer, "", listener);
            writer.flush();
        }
        finally {
            qt.unlock();
        }
    }

    public static void dumpComponent(Component comp, PrintWriter writer) {
        Dumper.dumpComponent(comp, writer, new DumpController(){

            public boolean onComponentDump(Component comp) {
                return true;
            }

            public boolean onPropertyDump(Component comp, String name, String value) {
                return true;
            }
        });
    }

    public static void dumpComponent(Component comp, PrintStream writer) {
        Dumper.dumpComponent(comp, new PrintWriter(writer));
    }

    public static void dumpComponent(Component comp, PrintStream writer, DumpController listener) {
        Dumper.dumpComponent(comp, new PrintWriter(writer), listener);
    }

    public static void dumpComponent(Component comp, String fileName) throws FileNotFoundException {
        Dumper.dumpComponent(comp, new PrintWriter(new FileOutputStream(fileName)));
    }

    public static void dumpComponent(Component comp, String fileName, DumpController listener) throws FileNotFoundException {
        Dumper.dumpComponent(comp, new PrintWriter(new FileOutputStream(fileName)), listener);
    }

    public static void dumpAll(PrintWriter writer) {
        Dumper.dumpComponent(null, writer);
    }

    public static void dumpAll(PrintWriter writer, DumpController listener) {
        Dumper.dumpComponent(null, writer, listener);
    }

    public static void dumpAll(PrintStream writer) {
        Dumper.dumpAll(new PrintWriter(writer));
    }

    public static void dumpAll(PrintStream writer, DumpController listener) {
        Dumper.dumpAll(new PrintWriter(writer), listener);
    }

    public static void dumpAll(String fileName) throws FileNotFoundException {
        Dumper.dumpAll(new PrintWriter(new FileOutputStream(fileName)));
    }

    public static void dumpAll(String fileName, DumpController listener) throws FileNotFoundException {
        Dumper.dumpAll(new PrintWriter(new FileOutputStream(fileName)), listener);
    }

    private static void printTagStart(PrintWriter writer, String tag, String tab) {
        writer.println(tab + "<" + tag + ">");
    }

    private static void printTagOpening(PrintWriter writer, String tag, String tab) {
        writer.print(tab + "<" + tag);
    }

    private static void printTagClosing(PrintWriter writer, String tag) {
        writer.println(">");
    }

    private static void printTagEnd(PrintWriter writer, String tag, String tab) {
        writer.println(tab + "</" + tag + ">");
    }

    private static void printEmptyTagOpening(PrintWriter writer, String tag, String tab) {
        writer.print(tab + "<" + tag);
    }

    private static void printEmptyTagClosing(PrintWriter writer, String tag) {
        writer.println("/>");
    }

    private static void dumpSome(String tag, Component[] comps, PrintWriter writer, String tab, DumpController listener) {
        if (comps.length > 0) {
            Dumper.printTagStart(writer, tag, tab);
            for (int i = 0; i < comps.length; ++i) {
                Dumper.dumpOne(comps[i], writer, tab + tabIncrease, listener);
            }
            Dumper.printTagEnd(writer, tag, tab);
        }
    }

    private static void dumpOne(Component component, PrintWriter writer, String tab, DumpController listener) {
        boolean toDump = listener.onComponentDump(component);
        if (toDump) {
            try {
                ComponentOperator oper = Operator.createOperator(component);
                Hashtable componentDump = ((Operator)oper).getDump();
                Dumper.printTagOpening(writer, "component", tab);
                writer.print(" operator=\"" + oper.getClass().getName() + "\"");
                Dumper.printTagClosing(writer, "component");
                Object[] keys = componentDump.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    String name = (String)keys[i];
                    String value = ((String)componentDump.get(keys[i])).replace('\"', '\'');
                    if (!listener.onPropertyDump(component, name, value)) continue;
                    Dumper.printEmptyTagOpening(writer, "property", tab + tabIncrease);
                    writer.print(" name=\"" + name + "\" value=\"" + value + "\"");
                    Dumper.printEmptyTagClosing(writer, "property");
                }
            }
            catch (Exception e) {
                JemmyProperties.getCurrentOutput().printStackTrace(e);
                Dumper.printTagStart(writer, "component", tab);
                Dumper.printEmptyTagOpening(writer, "exception", tab + tabIncrease);
                writer.print(" toString=\"" + e.toString().replace('\"', '\'') + "\"");
                Dumper.printEmptyTagClosing(writer, "exception");
            }
        }
        if (component instanceof Window) {
            Dumper.dumpSome("subwindows", ((Window)component).getOwnedWindows(), writer, tab + tabIncrease, listener);
        }
        if (component instanceof Container) {
            Dumper.dumpSome("subcomponents", ((Container)component).getComponents(), writer, tab + tabIncrease, listener);
        }
        if (toDump) {
            Dumper.printTagEnd(writer, "component", tab);
        }
    }

    private static void printHeader(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\"?>");
        writer.println("<!DOCTYPE dump [");
        Dumper.printDTD(writer, tabIncrease);
        writer.println("]>");
    }

    private static void printDTD(PrintWriter writer, String tab) {
        writer.println(tab + "<!ELEMENT dump (component*)>");
        writer.println(tab + "<!ELEMENT component (property+, subcomponents?, subwindows?, exception?)>");
        writer.println(tab + "<!ELEMENT subcomponents (component+)>");
        writer.println(tab + "<!ELEMENT subwindows (component+)>");
        writer.println(tab + "<!ELEMENT property EMPTY>");
        writer.println(tab + "<!ELEMENT exception EMPTY>");
        writer.println(tab + "<!ATTLIST component");
        writer.println(tab + "          operator CDATA #IMPLIED>");
        writer.println(tab + "<!ATTLIST exception");
        writer.println(tab + "          toString CDATA #REQUIRED>");
        writer.println(tab + "<!ATTLIST property");
        writer.println(tab + "          name  CDATA #REQUIRED");
        writer.println(tab + "          value CDATA #REQUIRED>");
    }
}

