/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class WebResponseData
implements Serializable {
    private static final long serialVersionUID = 2979956380280496543L;
    private byte[] body_;
    private int statusCode_;
    private String statusMessage_;
    private List responseHeaders_;

    public WebResponseData(byte[] body, int statusCode, String statusMessage, List responseHeaders) {
        this.validateHeaders(responseHeaders);
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        try {
            this.body_ = this.getBody(new ByteArrayInputStream(body), responseHeaders);
        }
        catch (IOException e) {
            this.body_ = body;
        }
    }

    public WebResponseData(InputStream bodyStream, int statusCode, String statusMessage, List responseHeaders) throws IOException {
        this.validateHeaders(responseHeaders);
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
        this.body_ = this.getBody(bodyStream, responseHeaders);
    }

    protected WebResponseData(int statusCode, String statusMessage, List responseHeaders) throws IOException {
        this.validateHeaders(responseHeaders);
        this.statusCode_ = statusCode;
        this.statusMessage_ = statusMessage;
        this.responseHeaders_ = Collections.unmodifiableList(responseHeaders);
    }

    private void validateHeaders(List responseHeaders) {
        Iterator iterator = responseHeaders.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof NameValuePair) continue;
            String name = object.getClass().getName();
            String msg = "Only NameValuePairs may be in the response header list, but found a " + name + ".";
            throw new IllegalArgumentException(msg);
        }
    }

    protected byte[] getBody(InputStream stream, List headers) throws IOException {
        if (stream == null) {
            return null;
        }
        String encoding = null;
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            NameValuePair header = (NameValuePair)i.next();
            String headerName = header.getName().trim();
            if (!headerName.equalsIgnoreCase("content-encoding")) continue;
            encoding = header.getValue();
            break;
        }
        if (encoding != null && StringUtils.contains(encoding, (String)"gzip")) {
            stream = new GZIPInputStream(stream);
        }
        return IOUtils.toByteArray((InputStream)stream);
    }

    public byte[] getBody() {
        return this.body_;
    }

    public List getResponseHeaders() {
        return this.responseHeaders_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusMessage() {
        return this.statusMessage_;
    }
}

