/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResponseImpl
implements WebResponse,
Serializable {
    private static final long serialVersionUID = 2842434739251092348L;
    private final transient Log log_ = LogFactory.getLog((Class)WebResponseImpl.class);
    private URL url_;
    private SubmitMethod requestMethod_;
    private long loadTime_;
    private WebResponseData responseData_;
    private String charset_;

    public WebResponseImpl(WebResponseData responseData, URL url, SubmitMethod requestMethod, long loadTime) {
        this(responseData, "ISO-8859-1", url, requestMethod, loadTime);
    }

    public WebResponseImpl(WebResponseData responseData, String charset, URL url, SubmitMethod requestMethod, long loadTime) {
        this.responseData_ = responseData;
        this.charset_ = charset;
        this.url_ = url;
        this.requestMethod_ = requestMethod;
        this.loadTime_ = loadTime;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    public String getContentAsString() {
        try {
            byte[] body = this.responseData_.getBody();
            if (body != null) {
                return new String(body, this.getContentCharSet());
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public InputStream getContentAsStream() throws IOException {
        byte[] body = this.responseData_.getBody();
        if (body != null) {
            return new ByteArrayInputStream(body);
        }
        return null;
    }

    public URL getUrl() {
        return this.url_;
    }

    public SubmitMethod getRequestMethod() {
        return this.requestMethod_;
    }

    public List getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        Iterator iterator = this.responseData_.getResponseHeaders().iterator();
        while (iterator.hasNext()) {
            NameValuePair pair = (NameValuePair)iterator.next();
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public long getLoadTimeInMilliSeconds() {
        return this.loadTime_;
    }

    public String getContentCharSet() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        String charset = StringUtils.substringAfter((String)contentTypeHeader, (String)"charset=");
        if (StringUtils.isEmpty((String)charset)) {
            this.log_.debug((Object)"No charset specified in header, trying to guess it from content");
            byte[] body = this.responseData_.getBody();
            byte[] markerUTF8 = new byte[]{-17, -69, -65};
            byte[] markerUTF16BE = new byte[]{-2, -1};
            byte[] markerUTF16LE = new byte[]{-1, -2};
            if (body != null && ArrayUtils.isEquals((Object)markerUTF8, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)3))) {
                this.log_.debug((Object)"UTF-8 marker found");
                charset = "UTF-8";
            } else if (body != null && ArrayUtils.isEquals((Object)markerUTF16BE, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)2))) {
                this.log_.debug((Object)"UTF-16BE marker found");
                charset = "UTF-16BE";
            } else if (body != null && ArrayUtils.isEquals((Object)markerUTF16LE, (Object)ArrayUtils.subarray((byte[])body, (int)0, (int)2))) {
                this.log_.debug((Object)"UTF-16LE marker found");
                charset = "UTF-16LE";
            } else {
                this.log_.debug((Object)("No charset guessed, using " + this.charset_));
                charset = this.charset_;
            }
        } else if (charset.charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"' || charset.charAt(0) == '\'' && charset.charAt(charset.length() - 1) == '\'') {
            charset = charset.substring(1, charset.length() - 1);
        }
        return charset;
    }

    public byte[] getResponseBody() {
        return this.responseData_.getBody();
    }
}

