/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class HtmlAnchor
extends FocusableElement {
    private static final long serialVersionUID = 7968778206454737178L;
    public static final String TAG_NAME = "a";

    public HtmlAnchor(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlAnchor(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    protected Page doClickAction(Page defaultPage, String hrefSuffix) throws IOException {
        String href = this.getHrefAttribute() + hrefSuffix;
        this.getLog().debug((Object)("do click action in window '" + defaultPage.getEnclosingWindow().getName() + "', using href '" + href + "'"));
        if (href != null && href.length() > 0 && !href.startsWith("#")) {
            HtmlPage page = this.getPage();
            if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
                return page.executeJavaScriptIfPossible(href, "javascript url", this.getStartLineNumber()).getNewPage();
            }
            URL url = page.getFullyQualifiedUrl(href);
            WebRequestSettings settings = new WebRequestSettings(url);
            settings.addAdditionalHeader("Referer", page.getWebResponse().getUrl().toExternalForm());
            this.getLog().debug((Object)("Getting page for " + url.toExternalForm() + ", derived from href '" + href + "', using the originating url " + page.getWebResponse().getUrl()));
            return page.getWebClient().getPage(page.getEnclosingWindow(), page.getResolvedTarget(this.getTargetAttribute()), settings);
        }
        return defaultPage;
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        return this.doClickAction(defaultPage, "");
    }

    public final String getCharsetAttribute() {
        return this.getAttributeValue("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeValue("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getHrefAttribute() {
        return this.getAttributeValue("href").trim();
    }

    public final String getHrefLangAttribute() {
        return this.getAttributeValue("hreflang");
    }

    public final String getRelAttribute() {
        return this.getAttributeValue("rel");
    }

    public final String getRevAttribute() {
        return this.getAttributeValue("rev");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getShapeAttribute() {
        return this.getAttributeValue("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeValue("coords");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeValue("target");
    }

    public final Page openLinkInNewWindow() throws MalformedURLException {
        URL target = this.getPage().getFullyQualifiedUrl(this.getHrefAttribute());
        WebWindow newWindow = this.getPage().getWebClient().openWindow(target, "HtmlAnchor.openLinkInNewWindow() target");
        return newWindow.getEnclosedPage();
    }
}

