/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

public class HtmlCheckBoxInput
extends HtmlInput {
    private static final long serialVersionUID = 3567976425357413976L;
    private boolean defaultCheckedState_ = this.isAttributeDefined("checked");

    public HtmlCheckBoxInput(HtmlPage page, Map attributes) {
        this(null, "input", page, attributes);
    }

    HtmlCheckBoxInput(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", "on");
        }
    }

    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    public Page setChecked(boolean isChecked) {
        if (isChecked) {
            this.setAttributeValue("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        return HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
    }

    public String asText() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        this.setChecked(!this.isChecked());
        return super.doClickAction(defaultPage);
    }

    protected boolean isStateUpdateFirst() {
        return true;
    }

    protected void preventDefault() {
        this.setChecked(!this.isChecked());
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().isNetscape()) {
            this.setChecked(defaultChecked);
        }
    }

    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }
}

