/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.KeyDataPair;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HtmlFileInput
extends HtmlInput {
    private static final long serialVersionUID = 7925479292349207154L;
    private String contentType_;

    public HtmlFileInput(HtmlPage page, Map attributes) {
        this(null, "input", page, attributes);
    }

    HtmlFileInput(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        this.setAttributeValue("value", "");
        if (page.getWebClient().getBrowserVersion().isIE()) {
            this.setDefaultValue("");
        }
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        String value = this.getValueAttribute();
        if (StringUtils.isEmpty((String)value)) {
            return new KeyValuePair[]{new KeyDataPair(this.getNameAttribute(), new File(""), null, null)};
        }
        File file = null;
        if (value.startsWith("file:/")) {
            if (value.startsWith("file://") && !value.startsWith("file:///")) {
                value = "file:///" + value.substring(7);
            }
            try {
                file = new File(new URI(value));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(value);
        }
        String contentType = this.contentType_ == null ? this.getPage().getWebClient().guessContentType(file) : this.contentType_;
        String charset = this.getPage().getPageEncoding();
        return new KeyValuePair[]{new KeyDataPair(this.getNameAttribute(), file, contentType, charset)};
    }

    public void reset() {
    }

    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, false);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }
}

