/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;

public class HtmlMeta
extends HtmlElement {
    private static final long serialVersionUID = 7408601325303605790L;
    public static final String TAG_NAME = "meta";

    public HtmlMeta(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlMeta(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if ("set-cookie".equalsIgnoreCase(this.getHttpEquivAttribute())) {
            this.performSetCookie();
        }
    }

    protected void performSetCookie() {
        String[] parts = this.getContentAttribute().split("\\s*;\\s*");
        String name = StringUtils.substringBefore((String)parts[0], (String)"=");
        String value = StringUtils.substringAfter((String)parts[0], (String)"=");
        Cookie cookie = new Cookie(this.getPage().getWebResponse().getUrl().getHost(), name, value);
        for (int i = 1; i < parts.length; ++i) {
            String partName = StringUtils.substringBefore((String)parts[i], (String)"=").trim().toLowerCase();
            String partValue = StringUtils.substringAfter((String)parts[i], (String)"=").trim();
            if ("path".equals(partName)) {
                cookie.setPath(partValue);
            } else if ("expires".equals(partName)) {
                try {
                    cookie.setExpiryDate(DateUtil.parseDate((String)partValue));
                }
                catch (DateParseException e) {
                    this.notifyIncorrectness("set-cookie http-equiv meta tag: can't parse expiration date >" + partValue + "<.");
                }
            } else {
                this.notifyIncorrectness("set-cookie http-equiv meta tag: unknown attribute >" + partName + "<");
            }
            this.getPage().getWebClient().getWebConnection().getState().addCookie(cookie);
        }
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getHttpEquivAttribute() {
        return this.getAttributeValue("http-equiv");
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getContentAttribute() {
        return this.getAttributeValue("content");
    }

    public final String getSchemeAttribute() {
        return this.getAttributeValue("scheme");
    }
}

