/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class HtmlTextArea
extends FocusableElement
implements DisabledElement,
SubmittableElement {
    private static final long serialVersionUID = 4572856255042499634L;
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;
    private int selectionStart_;
    private int selectionEnd_;
    private boolean preventDefault_;

    public HtmlTextArea(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlTextArea(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            DomText child = (DomText)this.getFirstDomChild();
            if (child != null) {
                this.defaultValue_ = child.getData();
                if (this.defaultValue_ == null) {
                    this.defaultValue_ = "";
                }
            } else {
                this.defaultValue_ = "";
            }
        }
    }

    public final String getText() {
        return this.getChildrenAsText();
    }

    public final void setText(String newValue) {
        this.initDefaultValue();
        DomText child = (DomText)this.getFirstDomChild();
        if (child == null) {
            DomText newChild = new DomText(this.getPage(), newValue);
            this.appendDomChild(newChild);
        } else {
            child.setData(newValue);
        }
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        this.setSelectionStart(newValue.length());
        this.setSelectionEnd(newValue.length());
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getText())};
    }

    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        this.defaultValue_ = defaultValue == null ? "" : defaultValue;
    }

    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    public void setDefaultChecked(boolean defaultChecked) {
    }

    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getRowsAttribute() {
        return this.getAttributeValue("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttributeValue("cols");
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeValue("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeValue("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeValue("onchange");
    }

    public String getSelectedText() {
        String text = null;
        if (this.selectionStart_ != this.selectionEnd_) {
            text = this.getText().substring(this.selectionStart_, this.selectionEnd_);
        }
        return text;
    }

    public int getSelectionStart() {
        return this.selectionStart_;
    }

    public void setSelectionStart(int selectionStart) {
        int length;
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > (length = this.getText().length())) {
            selectionStart = length;
        }
        if (this.selectionEnd_ < selectionStart) {
            this.selectionEnd_ = selectionStart;
        }
        this.selectionStart_ = selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd_;
    }

    public void setSelectionEnd(int selectionEnd) {
        int length;
        if (selectionEnd < 0) {
            selectionEnd = 0;
        }
        if (selectionEnd > (length = this.getText().length())) {
            selectionEnd = length;
        }
        if (selectionEnd < this.selectionStart_) {
            this.selectionStart_ = selectionEnd;
        }
        this.selectionEnd_ = selectionEnd;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(this.getText());
        printWriter.print(indent + "</textarea>");
    }

    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && this.isDisabled()) {
            return this.getPage();
        }
        this.preventDefault_ = false;
        Page page = super.type(c, shiftKey, ctrlKey, altKey);
        if (!Character.isWhitespace(c) && !this.preventDefault_) {
            this.setText(this.getText() + c);
        }
        return page;
    }

    protected void preventDefault() {
        this.preventDefault_ = true;
    }
}

