/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.NodeIterator;
import java.util.Iterator;

public final class Util {
    private Util() {
    }

    public static Iterator getFollowingSiblingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                return this.getNextNode(node);
            }

            protected DomNode getNextNode(DomNode node) {
                return node.getNextDomSibling();
            }
        };
    }

    public static Iterator getPrecedingSiblingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                return this.getNextNode(node);
            }

            protected DomNode getNextNode(DomNode node) {
                return node.getPreviousDomSibling();
            }
        };
    }

    public static Iterator getFollowingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode sibling = node.getNextDomSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentDomNode());
                }
                return sibling;
            }

            protected DomNode getNextNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode n = node.getFirstDomChild();
                if (n == null) {
                    n = node.getNextDomSibling();
                }
                if (n == null) {
                    return this.getFirstNode(node.getParentDomNode());
                }
                return n;
            }
        };
    }

    public static Iterator getPrecedingAxisIterator(DomNode contextNode) {
        return new NodeIterator(contextNode){

            protected DomNode getFirstNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode sibling = node.getPreviousDomSibling();
                if (sibling == null) {
                    return this.getFirstNode(node.getParentDomNode());
                }
                return sibling;
            }

            protected DomNode getNextNode(DomNode node) {
                if (node == null) {
                    return null;
                }
                DomNode n = node.getLastDomChild();
                if (n == null) {
                    n = node.getPreviousDomSibling();
                }
                if (n == null) {
                    return this.getFirstNode(node.getParentDomNode());
                }
                return n;
            }
        };
    }
}

