/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.Util;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.util.Collections;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class DocumentNavigator
extends DefaultNavigator {
    private static final long serialVersionUID = -5323715453687261210L;
    public static final DocumentNavigator instance = new DocumentNavigator();

    public Iterator getChildAxisIterator(Object contextNode) {
        return ((DomNode)contextNode).getChildIterator();
    }

    public Iterator getParentAxisIterator(final Object contextNode) {
        return new Iterator(){
            private DomNode parent_;
            {
                this.parent_ = ((DomNode)contextNode).getParentDomNode();
            }

            public boolean hasNext() {
                return this.parent_ != null;
            }

            public Object next() {
                DomNode next = this.parent_;
                this.parent_ = null;
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getFollowingSiblingAxisIterator(Object contextNode) {
        return Util.getFollowingSiblingAxisIterator((DomNode)contextNode);
    }

    public Iterator getPrecedingSiblingAxisIterator(Object contextNode) {
        return Util.getPrecedingSiblingAxisIterator((DomNode)contextNode);
    }

    public Iterator getFollowingAxisIterator(Object contextNode) {
        return Util.getFollowingAxisIterator((DomNode)contextNode);
    }

    public Iterator getPrecedingAxisIterator(Object contextNode) {
        return Util.getPrecedingAxisIterator((DomNode)contextNode);
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (contextNode instanceof HtmlElement) {
            return ((HtmlElement)contextNode).getAttributeEntriesIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public XPath parseXPath(String xpath) throws JaxenException {
        return new HtmlUnitXPath(xpath);
    }

    public Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof Page) {
            return (Page)contextNode;
        }
        if (contextNode instanceof XmlElement) {
            return ((DomNode)contextNode).getNativePage();
        }
        return ((DomNode)contextNode).getPage();
    }

    public String getElementNamespaceUri(Object element) {
        XmlElement xmlElement;
        if (element instanceof HtmlElement) {
            return "";
        }
        if (element instanceof XmlElement && (xmlElement = (XmlElement)element).getPrefix() != null) {
            return XmlUtil.lookupNamespaceURI(xmlElement, xmlElement.getPrefix());
        }
        return null;
    }

    public String getElementName(Object object) {
        if (object instanceof XmlElement) {
            return ((XmlElement)object).getLocalName();
        }
        return ((DomNode)object).getNodeName();
    }

    public String getElementQName(Object object) {
        if (object instanceof XmlElement) {
            return ((XmlElement)object).getQualifiedName();
        }
        return ((DomNode)object).getNodeName();
    }

    public String getAttributeNamespaceUri(Object object) {
        return "";
    }

    public String getAttributeName(Object object) {
        return ((HtmlAttr)object).getName();
    }

    public String getAttributeQName(Object object) {
        return ((HtmlAttr)object).getName();
    }

    public boolean isDocument(Object object) {
        return object instanceof HtmlPage;
    }

    public boolean isNamespace(Object object) {
        return false;
    }

    public boolean isElement(Object object) {
        return object instanceof DomNode && ((DomNode)object).getNodeType() == 1;
    }

    public boolean isAttribute(Object object) {
        return object instanceof HtmlAttr;
    }

    public boolean isComment(Object object) {
        return object instanceof DomComment;
    }

    public boolean isText(Object object) {
        return object instanceof DomText || object instanceof DomCharacterData;
    }

    public boolean isProcessingInstruction(Object object) {
        return false;
    }

    public String getElementStringValue(Object object) {
        return ((DomNode)object).asText();
    }

    public String getAttributeStringValue(Object object) {
        return (String)((HtmlAttr)object).getHtmlValue();
    }

    public String getTextStringValue(Object object) {
        return ((DomText)object).asText();
    }

    public String getCommentStringValue(Object object) {
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        return null;
    }

    public String getNamespacePrefix(Object object) {
        if (object instanceof XmlElement) {
            return ((XmlElement)object).getPrefix();
        }
        return null;
    }

    public Object getElementById(Object contextNode, String elementId) {
        HtmlPage page = ((DomNode)contextNode).getPage();
        try {
            return page.getHtmlElementById(elementId);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }
}

