/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.XMLHttpRequest;
import com.gargoylesoftware.htmlunit.javascript.host.XSLTemplate;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;

public class ActiveXObject
extends SimpleScriptable {
    private static final long serialVersionUID = 7327032075131452226L;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter must be a String.");
        }
        String activeXName = (String)args[0];
        if (ActiveXObject.isXMLHttpRequest(activeXName)) {
            return ActiveXObject.buildXMLHttpRequest();
        }
        if (ActiveXObject.isXMLDocument(activeXName)) {
            return ActiveXObject.buildXMLDocument(ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow());
        }
        if (ActiveXObject.isXMLTemplate(activeXName)) {
            return ActiveXObject.buildXSLTemplate();
        }
        Map map = ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow().getWebClient().getActiveXObjectMap();
        if (map == null) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: the map is null.");
        }
        Object mapValue = map.get(activeXName);
        if (mapValue == null) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: no value for " + activeXName + "."));
        }
        if (!(mapValue instanceof String)) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: value for " + activeXName + " is not a String."));
        }
        String xClassString = (String)mapValue;
        Object object = null;
        try {
            Class<?> xClass = Class.forName(xClassString);
            object = xClass.newInstance();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + "."));
        }
        return Context.toObject(object, (Scriptable)ctorObj);
    }

    static boolean isXMLHttpRequest(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLHTTP".equalsIgnoreCase(name = name.toLowerCase()) || name.startsWith("Msxml2.XMLHTTP".toLowerCase());
    }

    static boolean isXMLDocument(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLDOM".equalsIgnoreCase(name = name.toLowerCase()) || name.matches("msxml\\d*\\.domdocument.*") || name.matches("msxml\\d*\\.freethreadeddomdocument.*");
    }

    static boolean isXMLTemplate(String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        return name.matches("msxml\\d*\\.xsltemplate.*");
    }

    private static Scriptable buildXMLHttpRequest() {
        XMLHttpRequest scriptable = new XMLHttpRequest();
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "onreadystatechange", true, true);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "readyState", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseText", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseXML", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "status", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "statusText", true, false);
        ActiveXObject.addFunction(scriptable, "abort");
        ActiveXObject.addFunction(scriptable, "getAllResponseHeaders");
        ActiveXObject.addFunction(scriptable, "getResponseHeader");
        ActiveXObject.addFunction(scriptable, "open");
        ActiveXObject.addFunction(scriptable, "send");
        ActiveXObject.addFunction(scriptable, "setRequestHeader");
        return scriptable;
    }

    private static Scriptable buildXSLTemplate() {
        XSLTemplate scriptable = new XSLTemplate();
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "stylesheet", true, true);
        ActiveXObject.addFunction(scriptable, "createProcessor");
        return scriptable;
    }

    static XMLDocument buildXMLDocument(WebWindow enclosingWindow) {
        XMLDocument document = new XMLDocument(enclosingWindow);
        ActiveXObject.addProperty((SimpleScriptable)document, "async", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "parseError", true, false);
        ActiveXObject.addProperty((SimpleScriptable)document, "preserveWhiteSpace", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "xml", true, false);
        ActiveXObject.addFunction(document, "load");
        ActiveXObject.addFunction(document, "loadXML");
        ActiveXObject.addFunction(document, "selectNodes");
        ActiveXObject.addFunction(document, "selectSingleNode");
        ActiveXObject.addFunction(document, "setProperty");
        JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.INTERNET_EXPLORER_7_0);
        String className = "Document";
        while (className.trim().length() != 0) {
            ClassConfiguration classConfig = jsConfig.getClassConfiguration(className);
            Iterator iterator = classConfig.functionKeys().iterator();
            while (iterator.hasNext()) {
                String function = (String)iterator.next();
                ActiveXObject.addFunction(document, function);
            }
            iterator = classConfig.propertyKeys().iterator();
            while (iterator.hasNext()) {
                String property;
                ActiveXObject.addProperty((SimpleScriptable)document, property, classConfig.getPropertyReadMethod(property = (String)iterator.next()) != null, classConfig.getPropertyWriteMethod(property) != null);
            }
            className = classConfig.getExtendedClass();
        }
        return document;
    }

    private static void addFunction(SimpleScriptable scriptable, String jsMethodName) {
        ActiveXObject.addFunction(scriptable, jsMethodName, "jsxFunction_" + jsMethodName);
    }

    private static void addFunction(SimpleScriptable scriptable, String jsMethodName, String javaMethodName) {
        Method javaFunction = ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), javaMethodName);
        FunctionObject fo = new FunctionObject(null, (Member)javaFunction, (Scriptable)scriptable);
        scriptable.defineProperty(jsMethodName, fo, 1);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, boolean isGetter, boolean isSetter) {
        String getterName = null;
        if (isGetter) {
            getterName = "jsxGet_" + propertyName;
        }
        String setterName = null;
        if (isSetter) {
            setterName = "jsxSet_" + propertyName;
        }
        ActiveXObject.addProperty(scriptable, propertyName, getterName, setterName);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, String getterName, String setterName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), getterName), ActiveXObject.getMethod(((Object)((Object)scriptable)).getClass(), setterName), 4);
    }

    static Method getMethod(Class clazz, String name) {
        if (name == null) {
            return null;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    public String getClassName() {
        return "ActiveXObject";
    }
}

