/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.JavaScriptBackgroundJob;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Popup;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Style;
import com.gargoylesoftware.htmlunit.javascript.host.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class Window
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private static final long serialVersionUID = -7730298149962810325L;
    private Document document_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private Object event_;
    private String status_ = "";
    private HTMLCollection frames_;
    private Map prototypes_ = new HashMap();
    private final JavaScriptEngine scriptEngine_;
    private EventListenersContainer eventListenersContainer_;

    public Window(JavaScriptEngine scriptEngine) {
        this.scriptEngine_ = scriptEngine;
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.scriptEngine_;
    }

    public Scriptable getPrototype(Class jsClass) {
        return (Scriptable)this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map map) {
        this.prototypes_ = map;
    }

    public void jsxFunction_alert(Object message) {
        String stringMessage = Context.toString((Object)message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.alert(\"" + stringMessage + "\") no alert handler installed"));
        } else {
            handler.handleAlert(this.document_.getHtmlPage(), stringMessage);
        }
    }

    public boolean jsxFunction_confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button"));
            return true;
        }
        return handler.handleConfirm(this.document_.getHtmlPage(), message);
    }

    public String jsxFunction_prompt(String message) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            this.getLog().warn((Object)("window.prompt(\"" + message + "\") no prompt handler installed"));
            return null;
        }
        return handler.handlePrompt(this.document_.getHtmlPage(), message);
    }

    public Document jsxGet_document() {
        return this.document_;
    }

    public Object jsxGet_event() {
        return this.event_;
    }

    public void setEvent(Object event) {
        this.event_ = event;
    }

    public static Object jsxFunction_open(Context context, Scriptable scriptable, Object[] args, Function function) {
        String url = Window.getStringArg(0, args, null);
        String windowName = Window.getStringArg(1, args, "");
        String features = Window.getStringArg(2, args, null);
        boolean replaceCurrentEntryInBrowsingHistory = Window.getBooleanArg(3, args, false);
        Window thisWindow = (Window)scriptable;
        WebClient webClient = thisWindow.webWindow_.getWebClient();
        if (webClient.isPopupBlockerEnabled()) {
            thisWindow.getLog().debug((Object)"Ignoring window.open() invocation because popups are blocked.");
            return null;
        }
        if (features != null || replaceCurrentEntryInBrowsingHistory) {
            thisWindow.getLog().debug((Object)("Window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + url + "] windowName=[" + windowName + "] features=[" + features + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]"));
        }
        if (StringUtils.isEmpty((String)url) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return webWindow.getScriptObject();
            }
            catch (WebWindowNotFoundException e) {
                // empty catch block
            }
        }
        URL newUrl = thisWindow.makeUrlForOpenWindow(url);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, thisWindow.webWindow_);
        return newWebWindow.getScriptObject();
    }

    public static Popup jsxFunction_createPopup(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Popup popup = new Popup();
        popup.setParentScope(thisWindow);
        popup.setPrototype(thisWindow.getPrototype(Popup.class));
        popup.init(thisWindow);
        return popup;
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.length() == 0) {
            if (this.getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                return WebClient.URL_ABOUT_BLANK;
            }
            return null;
        }
        try {
            Page page = this.webWindow_.getEnclosedPage();
            if (page != null && page instanceof HtmlPage) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to create url for openWindow: relativeUrl=[" + urlString + "]"), (Throwable)e);
            return null;
        }
    }

    private static JavaScriptBackgroundJob createJavaScriptBackgroundJob(Object codeToExec, int timeout, Window thisWindow, boolean loopForever, String label) {
        if (codeToExec == null) {
            throw Context.reportRuntimeError((String)"Function not provided");
        }
        if (codeToExec instanceof String) {
            String scriptString = (String)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptString, loopForever, label);
        }
        if (codeToExec instanceof Function) {
            Function scriptFunction = (Function)codeToExec;
            return new JavaScriptBackgroundJob(thisWindow, timeout, scriptFunction, loopForever, label);
        }
        throw Context.reportRuntimeError((String)"Unknown type for function");
    }

    public static int jsxFunction_setTimeout(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Object codeToExec = Window.getObjectArg(0, args, null);
        int timeout = Window.getIntArg(1, args, 0);
        thisWindow.getLog().debug((Object)("setTimeout(" + codeToExec + ", " + timeout + ")"));
        JavaScriptBackgroundJob job = Window.createJavaScriptBackgroundJob(codeToExec, timeout, thisWindow, false, "setTimeout");
        int id = thisWindow.getWebWindow().getThreadManager().startThread(job, "window.setTimeout");
        return id;
    }

    public void jsxFunction_clearTimeout(int timeoutId) {
        this.getWebWindow().getThreadManager().stopThread(timeoutId);
    }

    public Navigator jsxGet_navigator() {
        return this.navigator_;
    }

    public Window jsxGet_window() {
        return this;
    }

    public Window jsxGet_self() {
        return this;
    }

    public Location jsxGet_location() {
        return this.location_;
    }

    public void jsxSet_location(String newLocation) throws IOException {
        this.location_.jsxSet_href(newLocation);
    }

    public Screen jsxGet_screen() {
        return this.screen_;
    }

    public History jsxGet_history() {
        return this.history_;
    }

    public void initialize(WebWindow webWindow) throws Exception {
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptObject(this);
        this.document_ = new Document();
        this.document_.setParentScope(this);
        this.document_.setPrototype(this.getPrototype(Document.class));
        this.document_.setWindow(this);
        if (webWindow.getEnclosedPage() instanceof HtmlPage) {
            this.document_.setDomNode((DomNode)((Object)webWindow.getEnclosedPage()));
        }
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope(this);
        this.navigator_.setPrototype(this.getPrototype(Navigator.class));
        this.screen_ = new Screen();
        this.screen_.setParentScope(this);
        this.screen_.setPrototype(this.getPrototype(Screen.class));
        this.history_ = new History();
        this.history_.setParentScope(this);
        this.history_.setPrototype(this.getPrototype(History.class));
        this.location_ = new Location();
        this.location_.setParentScope(this);
        this.location_.setPrototype(this.getPrototype(Location.class));
        this.location_.initialize(this);
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            Assert.notNull("document_", (Object)this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    public SimpleScriptable jsxGet_top() {
        WebWindow topWebWindow = this.webWindow_.getTopWindow();
        return (SimpleScriptable)((Object)topWebWindow.getScriptObject());
    }

    public SimpleScriptable jsxGet_parent() {
        WebWindow parentWebWindow = this.webWindow_.getParentWindow();
        return (SimpleScriptable)((Object)parentWebWindow.getScriptObject());
    }

    public Object jsxGet_opener() {
        WebWindow opener;
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            return opener.getScriptObject();
        }
        return null;
    }

    public Object jsxGet_frameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptObject();
        }
        return null;
    }

    public HTMLCollection jsxGet_frames() {
        if (this.frames_ == null) {
            HtmlUnitXPath xpath;
            try {
                xpath = new HtmlUnitXPath("//*[(name() = 'frame' or name() = 'iframe')]");
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed initializing frame collections: " + e.getMessage()));
            }
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            this.frames_ = new HTMLCollection(this);
            Transformer toEnclosedWindow = new Transformer(){

                public Object transform(Object obj) {
                    if (obj instanceof BaseFrame) {
                        return ((BaseFrame)obj).getEnclosedWindow();
                    }
                    return ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
                }
            };
            this.frames_.init(page, (XPath)xpath, toEnclosedWindow);
        }
        return this.frames_;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void jsxFunction_focus() {
        this.webWindow_.getWebClient().setCurrentWindow(this.webWindow_);
    }

    public void jsxFunction_blur() {
        this.getLog().debug((Object)"Window.blur() not implemented");
    }

    public void jsxFunction_close() {
        this.getWebWindow().getWebClient().deregisterWebWindow(this.getWebWindow());
    }

    public boolean jsxGet_closed() {
        return !this.getWebWindow().getWebClient().getWebWindows().contains(this.getWebWindow());
    }

    public void jsxFunction_moveTo(int x, int y) {
        this.getLog().debug((Object)"Window.moveTo() not implemented");
    }

    public void jsxFunction_moveBy(int x, int y) {
        this.getLog().debug((Object)"Window.moveBy() not implemented");
    }

    public void jsxFunction_resizeBy(int width, int height) {
        this.getLog().debug((Object)"Window.resizeBy() not implemented");
    }

    public void jsxFunction_resizeTo(int width, int height) {
        this.getLog().debug((Object)"Window.resizeTo() not implemented");
    }

    public void jsxFunction_scroll(int x, int y) {
        this.getLog().debug((Object)"Window.scroll() not implemented");
    }

    public void jsxFunction_scrollBy(int x, int y) {
        this.getLog().debug((Object)"Window.scrollBy() not implemented");
    }

    public void jsxFunction_scrollByLines(int lines) {
        this.getLog().debug((Object)"Window.scrollByLines() not implemented");
    }

    public void jsxFunction_scrollByPages(int pages) {
        this.getLog().debug((Object)"Window.scrollByPages() not implemented");
    }

    public void jsxFunction_scrollTo(int x, int y) {
        this.getLog().debug((Object)"Window.scrollTo() not implemented");
    }

    public void jsxSet_onload(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("load", newOnload);
    }

    public void jsxSet_onclick(Object newOnload) {
        this.getEventListenersContainer().setEventHandlerProp("click", newOnload);
    }

    public Object jsxGet_onclick() {
        return this.getEventListenersContainer().getEventHandlerProp("click");
    }

    public void jsxSet_ondblclick(Object newHandler) {
        this.getEventListenersContainer().setEventHandlerProp("dblclick", newHandler);
    }

    public Object jsxGet_ondblclick() {
        return this.getEventListenersContainer().getEventHandlerProp("dblclick");
    }

    public Object jsxGet_onload() {
        Object onload = this.getEventListenersContainer().getEventHandlerProp("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.webWindow_.getEnclosedPage();
            List<String> listTagNames = Arrays.asList("body", "frameset");
            List listElements = page.getDocumentHtmlElement().getHtmlElementsByTagNames(listTagNames);
            if (!listElements.isEmpty()) {
                return ((HtmlElement)listElements.get(0)).getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.getEventListenersContainer().removeEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    public String jsxGet_name() {
        return this.webWindow_.getName();
    }

    public void jsxSet_name(String newName) {
        this.webWindow_.setName(newName);
    }

    public String jsxGet_onerror() {
        this.getLog().debug((Object)"Window.onerror not implemented");
        return "";
    }

    public void jsxSet_onerror(String newValue) {
        this.getLog().debug((Object)"Window.onerror not implemented");
    }

    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            result = this.getFrameByName(domNode.getPage(), name);
        }
        if (result == NOT_FOUND && domNode != null && domNode.getPage().getWebClient().getBrowserVersion().isIE()) {
            HTMLCollection array = (HTMLCollection)((Object)this.document_.jsxFunction_getElementsByName(name));
            int length = array.jsxGet_length();
            if (length == 1) {
                result = array.get(0, (Scriptable)array);
            } else if (length > 1) {
                result = array;
            } else {
                result = this.document_.jsxFunction_getElementById(name);
                if (result == null) {
                    result = NOT_FOUND;
                }
            }
        }
        return result;
    }

    public Object get(String name, Scriptable start) {
        Window w;
        if ("eval".equals(name) && (w = (Window)this.getTopScope(this.getStartingScope())) != this) {
            return this.getAssociatedValue("custom_eval");
        }
        return super.get(name, start);
    }

    private Scriptable getTopScope(Scriptable s) {
        Scriptable top;
        for (top = s; top != null && top.getParentScope() != null; top = top.getParentScope()) {
        }
        return top;
    }

    private Object getFrameByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    public Object jsxFunction_execScript(String script, String language) {
        if ("javascript".equalsIgnoreCase(language) || "jscript".equalsIgnoreCase(language)) {
            this.custom_eval(script);
            return null;
        }
        if (!"vbscript".equalsIgnoreCase(language)) {
            throw Context.reportRuntimeError((String)"Invalid class string");
        }
        this.getLog().warn((Object)"VBScript not supported in Window.execScript().");
        return null;
    }

    public Object custom_eval(String scriptCode) {
        Context context = Context.getCurrentContext();
        Script script = context.compileString(scriptCode, "eval body", 0, null);
        return script.exec(context, (Scriptable)this);
    }

    public String jsxGet_status() {
        return this.status_;
    }

    public void jsxSet_status(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    public static int jsxFunction_setInterval(Context context, Scriptable scriptable, Object[] args, Function function) {
        Window thisWindow = (Window)scriptable;
        Object codeToExec = Window.getObjectArg(0, args, null);
        int timeout = Window.getIntArg(1, args, 0);
        thisWindow.getLog().debug((Object)("setInterval(" + codeToExec + ", " + timeout + ")"));
        JavaScriptBackgroundJob job = Window.createJavaScriptBackgroundJob(codeToExec, timeout, thisWindow, true, "setInterval");
        int id = thisWindow.getWebWindow().getThreadManager().startThread(job, "window.setInterval");
        return id;
    }

    public void jsxFunction_clearInterval(int intervalID) {
        this.getWebWindow().getThreadManager().stopThread(intervalID);
    }

    public int jsxGet_innerWidth() {
        return 1276;
    }

    public int jsxGet_outerWidth() {
        return 1276;
    }

    public int jsxGet_innerHeight() {
        return 778;
    }

    public int jsxGet_outerHeight() {
        return 936;
    }

    public void jsxFunction_print() {
        this.getLog().debug((Object)"window.print() not implemented");
    }

    public void jsxFunction_captureEvents(String type) {
    }

    public Object jsxFunction_getComputedStyle(Node element, String pseudoElt) {
        HTMLElement e = (HTMLElement)element;
        Style original = (Style)e.jsxGet_style();
        Style style = original.createClone();
        style.setWriteMode((short)1);
        StyleSheetList sheets = (StyleSheetList)((Object)this.document_.jsxGet_styleSheets());
        for (int i = 0; i < sheets.jsxGet_length(); ++i) {
            Stylesheet sheet = sheets.jsxFunction_item(i);
            sheet.modifyIfNecessary(style, e);
        }
        style.setWriteMode((short)2);
        return style;
    }
}

