/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDocument;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.ArrayUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class XMLHttpRequest
extends SimpleScriptable {
    private static final long serialVersionUID = 2369039843039430664L;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public static final int STATE_INTERACTIVE = 3;
    public static final int STATE_COMPLETED = 4;
    private int state_ = 0;
    private Function stateChangeHandler_;
    private WebRequestSettings requestSettings_;
    private boolean async_;
    private int threadID_;
    private WebResponse webResponse_;
    private String overriddenMimeType_;
    private HtmlPage containingPage_;

    public void jsConstructor() {
    }

    public Function jsxGet_onreadystatechange() {
        return this.stateChangeHandler_;
    }

    public void jsxSet_onreadystatechange(Function stateChangeHandler) {
        this.stateChangeHandler_ = stateChangeHandler;
    }

    private void setState(int state, Context context) {
        this.state_ = state;
        if (this.stateChangeHandler_ != null) {
            if (context == null) {
                context = Context.getCurrentContext();
            }
            Scriptable scope = this.stateChangeHandler_.getParentScope();
            JavaScriptEngine jsEngine = this.containingPage_.getWebClient().getJavaScriptEngine();
            int nbExecutions = this.async_ && 1 == state ? 2 : 1;
            for (int i = 0; i < nbExecutions; ++i) {
                this.getLog().debug((Object)("Calling onreadystatechange handler for state " + state));
                jsEngine.callFunction(this.containingPage_, this.stateChangeHandler_, context, (Scriptable)this, scope, ArrayUtils.EMPTY_OBJECT_ARRAY);
                this.getLog().debug((Object)("onreadystatechange handler: " + context.decompileFunction(this.stateChangeHandler_, 4)));
                this.getLog().debug((Object)("Calling onreadystatechange handler for state " + state + ". Done."));
            }
        }
    }

    public int jsxGet_readyState() {
        return this.state_;
    }

    public String jsxGet_responseText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getContentAsString();
        }
        this.getLog().debug((Object)"XMLHttpRequest.responseText was retrieved before the response was available.");
        return "";
    }

    public Object jsxGet_responseXML() {
        if (this.webResponse_.getContentType().indexOf("xml") != -1) {
            try {
                XMLDocument doc;
                XmlPage page = new XmlPage(this.webResponse_, this.getWindow().getWebWindow());
                if (page.getWebClient().getBrowserVersion().isIE()) {
                    doc = ActiveXObject.buildXMLDocument(null);
                } else {
                    doc = new XMLDocument();
                    doc.setPrototype(this.getPrototype(((Object)((Object)doc)).getClass()));
                }
                doc.setParentScope(this.getWindow());
                doc.setDomNode(page);
                return doc;
            }
            catch (Exception e) {
                this.getLog().warn((Object)("Failed parsing xml document " + this.webResponse_.getUrl() + ": " + e.getMessage()));
                return null;
            }
        }
        this.getLog().debug((Object)("XMLHttpRequest.responseXML was called but the response is " + this.webResponse_.getContentType()));
        return null;
    }

    public int jsxGet_status() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusCode();
        }
        this.getLog().error((Object)"XMLHttpRequest.status was retrieved before the response was available.");
        return 0;
    }

    public String jsxGet_statusText() {
        if (this.webResponse_ != null) {
            return this.webResponse_.getStatusMessage();
        }
        this.getLog().error((Object)"XMLHttpRequest.statusText was retrieved before the response was available.");
        return null;
    }

    public void jsxFunction_abort() {
        this.getWindow().getWebWindow().getThreadManager().stopThread(this.threadID_);
    }

    public String jsxFunction_getAllResponseHeaders() {
        if (this.webResponse_ != null) {
            StringBuffer buffer = new StringBuffer();
            List headers = this.webResponse_.getResponseHeaders();
            Iterator i = headers.iterator();
            while (i.hasNext()) {
                NameValuePair header = (NameValuePair)i.next();
                buffer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            }
            return buffer.toString();
        }
        this.getLog().error((Object)"XMLHttpRequest.getAllResponseHeaders() was called before the response was available.");
        return null;
    }

    public String jsxFunction_getResponseHeader(String headerName) {
        if (this.webResponse_ != null) {
            return this.webResponse_.getResponseHeaderValue(headerName);
        }
        this.getLog().error((Object)"XMLHttpRequest.getResponseHeader() was called before the response was available.");
        return null;
    }

    public void jsxFunction_open(String method, String url, boolean async, String user, String password) {
        this.containingPage_ = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        try {
            URL fullUrl = this.containingPage_.getFullyQualifiedUrl(url);
            WebRequestSettings settings = new WebRequestSettings(fullUrl);
            settings.addAdditionalHeader("Referer", this.containingPage_.getWebResponse().getUrl().toExternalForm());
            SubmitMethod submitMethod = SubmitMethod.getInstance(method);
            settings.setSubmitMethod(submitMethod);
            if (user != null) {
                DefaultCredentialsProvider dcp = new DefaultCredentialsProvider();
                dcp.addCredentials(user, password);
                settings.setCredentialsProvider(dcp);
            }
            this.requestSettings_ = settings;
        }
        catch (MalformedURLException e) {
            this.getLog().error((Object)("Unable to initialize XMLHttpRequest using malformed URL '" + url + "'."));
            return;
        }
        this.async_ = async;
        this.setState(1, null);
    }

    public void jsxFunction_send(Object content) {
        this.prepareRequest(content);
        AjaxController ajaxController = this.getWindow().getWebWindow().getWebClient().getAjaxController();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        boolean synchron = ajaxController.processSynchron(page, this.requestSettings_, this.async_);
        if (synchron) {
            this.doSend(Context.getCurrentContext());
        } else {
            final Window startingScope = this.getWindow();
            final ContextAction action = new ContextAction(){

                public Object run(Context cx) {
                    cx.putThreadLocal((Object)"startingScope", startingScope);
                    XMLHttpRequest.this.doSend(cx);
                    return null;
                }
            };
            Runnable t = new Runnable(){

                public void run() {
                    Context.call((ContextAction)action);
                }
            };
            this.getLog().debug((Object)"Starting XMLHttpRequest thread for asynchronous request");
            this.threadID_ = this.getWindow().getWebWindow().getThreadManager().startThread(t, "XMLHttpRequest.send");
        }
    }

    private void prepareRequest(Object content) {
        String body;
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        if (Context.getUndefinedValue().equals(content) && wc.getBrowserVersion().isNetscape()) {
            throw Context.reportRuntimeError((String)"XMLHttpRequest.send: not enough arguments");
        }
        if (content != null && !Context.getUndefinedValue().equals(content) && (body = Context.toString((Object)content)).length() > 0) {
            this.getLog().debug((Object)("Setting request body to: " + body));
            this.requestSettings_.setRequestBody(body);
            this.requestSettings_.setCharset("UTF-8");
        }
    }

    private void doSend(Context context) {
        WebClient wc = this.getWindow().getWebWindow().getWebClient();
        try {
            this.setState(2, context);
            WebResponse webResponse = wc.loadWebResponse(this.requestSettings_);
            this.webResponse_ = this.overriddenMimeType_ == null ? webResponse : new WebResponseWrapper(webResponse){

                public String getContentType() {
                    return XMLHttpRequest.this.overriddenMimeType_;
                }
            };
            this.setState(3, context);
            this.setState(4, context);
        }
        catch (IOException e) {
            this.setState(1, context);
            throw Context.reportRuntimeError((String)("Unable to send the XMLHttpRequest: " + e));
        }
    }

    public void jsxFunction_setRequestHeader(String name, String value) {
        if (this.requestSettings_ == null) {
            throw Context.reportRuntimeError((String)"The open() method must be called before setRequestHeader().");
        }
        this.requestSettings_.addAdditionalHeader(name, value);
    }

    public void jsxFunction_overrideMimeType(String mimeType) {
        this.overriddenMimeType_ = mimeType;
    }
}

