/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import com.gargoylesoftware.htmlunit.util.WebResponseWrapper;
import java.io.IOException;
import java.net.URL;

public abstract class FalsifyingWebConnection
extends WebConnectionWrapper {
    public FalsifyingWebConnection(WebConnection webConnection) throws IllegalArgumentException {
        super(webConnection);
    }

    public FalsifyingWebConnection(WebClient webClient) throws IllegalArgumentException {
        super(webClient);
    }

    protected WebResponse deliverFromAlternateUrl(WebRequestSettings webRequestSettings, URL url) throws IOException {
        final URL originalUrl = webRequestSettings.getURL();
        webRequestSettings.setURL(url);
        WebResponse resp = super.getResponse(webRequestSettings);
        return new WebResponseWrapper(resp){

            public URL getUrl() {
                return originalUrl;
            }
        };
    }

    protected WebResponse replaceContent(WebResponse webResponse, String newContent) throws IOException {
        byte[] body = newContent.getBytes(webResponse.getContentCharSet());
        WebResponseData wrd = new WebResponseData(body, webResponse.getStatusCode(), webResponse.getStatusMessage(), webResponse.getResponseHeaders());
        return new WebResponseImpl(wrd, webResponse.getUrl(), webResponse.getRequestMethod(), webResponse.getLoadTimeInMilliSeconds());
    }
}

