/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

public final class FormEncodingType {
    public static final FormEncodingType URL_ENCODED = new FormEncodingType("application/x-www-form-urlencoded");
    public static final FormEncodingType MULTIPART = new FormEncodingType("multipart/form-data");
    private final String name_;

    private FormEncodingType(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public static FormEncodingType getInstance(String name) {
        String lowerCaseName = name.toLowerCase();
        FormEncodingType[] allInstances = new FormEncodingType[]{URL_ENCODED, MULTIPART};
        for (int i = 0; i < allInstances.length; ++i) {
            if (!allInstances[i].getName().equals(lowerCaseName)) continue;
            return allInstances[i];
        }
        if (name.equals("")) {
            return URL_ENCODED;
        }
        throw new IllegalArgumentException("No encoding type found for [" + name + "]");
    }

    public String toString() {
        return "EncodingType[name=" + this.getName() + "]";
    }
}

