/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.KeyDataPair;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnectionImpl;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;

public class HttpWebConnection
extends WebConnectionImpl {
    private HttpClient httpClient_;
    private String virtualHost_;

    public HttpWebConnection(WebClient webClient) {
        super(webClient);
    }

    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        URL url = webRequestSettings.getURL();
        HttpClient httpClient = this.getHttpClient();
        HttpMethodBase httpMethod = this.makeHttpMethod(webRequestSettings);
        try {
            HostConfiguration hostConfiguration = this.getHostConfiguration(webRequestSettings);
            long startTime = System.currentTimeMillis();
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)httpMethod);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse(responseCode, httpMethod, url, endTime - startTime, webRequestSettings.getCharset());
            return webResponse;
        }
        catch (HttpException e) {
            if (url.getPath().length() == 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(url.getProtocol());
                buffer.append("://");
                buffer.append(url.getHost());
                buffer.append("/");
                if (url.getQuery() != null) {
                    buffer.append(url.getQuery());
                }
                WebRequestSettings newRequest = new WebRequestSettings(new URL(buffer.toString()));
                newRequest.setSubmitMethod(webRequestSettings.getSubmitMethod());
                newRequest.setRequestParameters(webRequestSettings.getRequestParameters());
                newRequest.setAdditionalHeaders(webRequestSettings.getAdditionalHeaders());
                WebResponse webResponse = this.getResponse(newRequest);
                return webResponse;
            }
            e.printStackTrace();
            throw new RuntimeException("HTTP Error: " + e.getMessage());
        }
        finally {
            this.onResponseGenerated(httpMethod);
        }
    }

    protected void onResponseGenerated(HttpMethodBase httpMethod) {
        httpMethod.releaseConnection();
    }

    private HostConfiguration getHostConfiguration(WebRequestSettings webRequestSettings) {
        URI uri;
        HostConfiguration hostConfiguration = new HostConfiguration();
        URL url = webRequestSettings.getURL();
        try {
            uri = new URI(url.toExternalForm(), false);
        }
        catch (URIException e) {
            throw new IllegalStateException("Unable to create URI from URL: " + url.toExternalForm());
        }
        hostConfiguration.setHost(uri);
        if (webRequestSettings.getProxyHost() != null) {
            String proxyHost = webRequestSettings.getProxyHost();
            int proxyPort = webRequestSettings.getProxyPort();
            hostConfiguration.setProxy(proxyHost, proxyPort);
        }
        return hostConfiguration;
    }

    private HttpMethodBase makeHttpMethod(WebRequestSettings webRequestSettings) throws IOException {
        String path = webRequestSettings.getURL().getPath();
        if (path.length() == 0) {
            path = "/";
        } else if (path.startsWith("//")) {
            path = "//" + path;
        }
        HttpMethodBase httpMethod = this.buildHttpMethod(webRequestSettings.getSubmitMethod(), path);
        if (!(httpMethod instanceof EntityEnclosingMethod)) {
            if (webRequestSettings.getRequestParameters().isEmpty()) {
                String queryString = webRequestSettings.getURL().getQuery();
                httpMethod.setQueryString(queryString);
            } else {
                NameValuePair[] pairs = new NameValuePair[webRequestSettings.getRequestParameters().size()];
                webRequestSettings.getRequestParameters().toArray(pairs);
                httpMethod.setQueryString(pairs);
            }
        } else {
            Iterator iterator;
            EntityEnclosingMethod method = (EntityEnclosingMethod)httpMethod;
            method.getParams().setContentCharset(webRequestSettings.getCharset());
            String queryString = webRequestSettings.getURL().getQuery();
            if (queryString != null) {
                method.setQueryString(queryString);
            }
            if (webRequestSettings.getRequestBody() != null) {
                String body = webRequestSettings.getRequestBody();
                String charset = webRequestSettings.getCharset();
                method.setRequestEntity((RequestEntity)new StringRequestEntity(body, null, charset));
            }
            if (webRequestSettings.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof PostMethod) {
                NameValuePair pair;
                PostMethod postMethod = (PostMethod)httpMethod;
                iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    pair = (NameValuePair)iterator.next();
                    postMethod.removeParameter(pair.getName(), pair.getValue());
                }
                iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    pair = (NameValuePair)iterator.next();
                    postMethod.addParameter(pair.getName(), pair.getValue());
                }
            } else {
                ArrayList<StringPart> partList = new ArrayList<StringPart>();
                iterator = webRequestSettings.getRequestParameters().iterator();
                while (iterator.hasNext()) {
                    StringPart newPart;
                    KeyValuePair pair = (KeyValuePair)((Object)iterator.next());
                    if (pair instanceof KeyDataPair) {
                        KeyDataPair pairWithFile = (KeyDataPair)pair;
                        String charset = webRequestSettings.getCharset();
                        newPart = this.buildFilePart(pairWithFile, charset);
                    } else {
                        newPart = new StringPart(pair.getName(), pair.getValue(), webRequestSettings.getCharset());
                        newPart.setContentType(null);
                    }
                    newPart.setTransferEncoding(null);
                    partList.add(newPart);
                }
                Part[] parts = new Part[partList.size()];
                parts = partList.toArray(parts);
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            }
        }
        httpMethod.setRequestHeader("User-Agent", this.getWebClient().getBrowserVersion().getUserAgent());
        this.writeRequestHeadersToHttpMethod((HttpMethod)httpMethod, webRequestSettings.getAdditionalHeaders());
        httpMethod.setFollowRedirects(false);
        if (webRequestSettings.getCredentialsProvider() != null) {
            httpMethod.getParams().setParameter("http.authentication.credential-provider", (Object)webRequestSettings.getCredentialsProvider());
        }
        if (this.getWebClient().isCookiesEnabled()) {
            httpMethod.getParams().setBooleanParameter("http.protocol.single-cookie-header", true);
            if (webRequestSettings.getCookiePolicy() != null) {
                httpMethod.getParams().setCookiePolicy(webRequestSettings.getCookiePolicy());
            } else {
                httpMethod.getParams().setCookiePolicy("compatibility");
            }
        } else {
            httpMethod.getParams().setCookiePolicy("ignoreCookies");
        }
        return httpMethod;
    }

    FilePart buildFilePart(final KeyDataPair pairWithFile, final String charset) throws FileNotFoundException {
        FilePart part = new FilePart(pairWithFile.getName(), pairWithFile.getValue(), pairWithFile.getFile(), pairWithFile.getContentType(), null){

            protected void sendDispositionHeader(OutputStream out) throws IOException {
                out.write(CONTENT_DISPOSITION_BYTES);
                out.write(QUOTE_BYTES);
                out.write(EncodingUtil.getAsciiBytes((String)this.getName()));
                out.write(QUOTE_BYTES);
                String filename = this.getSource().getFileName();
                if (filename != null) {
                    out.write(EncodingUtil.getAsciiBytes((String)"; filename="));
                    out.write(QUOTE_BYTES);
                    out.write(EncodingUtil.getBytes((String)this.getFileName(), (String)charset));
                    out.write(QUOTE_BYTES);
                }
            }

            private String getFileName() {
                if (pairWithFile.getFile() == null) {
                    return pairWithFile.getValue();
                }
                if (HttpWebConnection.this.getWebClient().getBrowserVersion().isIE()) {
                    return pairWithFile.getFile().getAbsolutePath();
                }
                return pairWithFile.getValue();
            }
        };
        part.setCharSet(null);
        return part;
    }

    private HttpMethodBase buildHttpMethod(SubmitMethod submitMethod, String path) {
        GetMethod method;
        if (SubmitMethod.GET == submitMethod) {
            method = new GetMethod(path);
        } else if (SubmitMethod.POST == submitMethod) {
            method = new PostMethod(path);
        } else {
            throw new IllegalStateException("Submit method not yet supported: " + submitMethod);
        }
        return method;
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            Log log = LogFactory.getLog((String)"httpclient.wire");
            if (log instanceof SimpleLog) {
                ((SimpleLog)log).setLevel(4);
            }
            this.httpClient_.getHttpConnectionManager().getParams().setSoTimeout(this.getTimeout());
            this.httpClient_.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimeout());
            if (this.virtualHost_ != null) {
                this.httpClient_.getParams().setVirtualHost(this.virtualHost_);
            }
        }
        this.httpClient_.getParams().setParameter("http.authentication.credential-provider", (Object)this.getWebClient().getCredentialsProvider());
        return this.httpClient_;
    }

    protected int getTimeout() {
        return this.getWebClient().getTimeout();
    }

    protected HttpClient createHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        return new HttpClient((HttpConnectionManager)connectionManager);
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    public HttpState getState() {
        return this.getHttpClient().getState();
    }

    private WebResponse makeWebResponse(int statusCode, HttpMethodBase method, URL originatingURL, long loadTime, String charset) throws IOException {
        String statusMessage = method.getStatusText();
        if (statusMessage == null || statusMessage.length() == 0) {
            statusMessage = HttpStatus.getStatusText((int)statusCode);
        }
        if (statusMessage == null) {
            statusMessage = "Unknown status code";
        }
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        Header[] array = method.getResponseHeaders();
        for (int i = 0; i < array.length; ++i) {
            headers.add(new NameValuePair(array[i].getName(), array[i].getValue()));
        }
        WebResponseData responseData = this.newWebResponseDataInstance(statusMessage, headers, statusCode, method);
        SubmitMethod requestMethod = SubmitMethod.getInstance(method.getName());
        return this.newWebResponseInstance(charset, responseData, loadTime, requestMethod, originatingURL);
    }

    protected WebResponseData newWebResponseDataInstance(String statusMessage, List headers, int statusCode, HttpMethodBase method) throws IOException {
        return new WebResponseData(method.getResponseBodyAsStream(), statusCode, statusMessage, headers);
    }

    protected WebResponse newWebResponseInstance(String charset, WebResponseData responseData, long loadTime, SubmitMethod requestMethod, URL originatingURL) {
        return new WebResponseImpl(responseData, charset, originatingURL, requestMethod, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestHeadersToHttpMethod(HttpMethod httpMethod, Map requestHeaders) {
        Map map = requestHeaders;
        synchronized (map) {
            Iterator iterator = requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                httpMethod.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

