/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptableObject;

public abstract class DomNode
implements Cloneable,
Serializable {
    public static final short DOCUMENT_NODE = 9;
    public static final short ELEMENT_NODE = 1;
    public static final short TEXT_NODE = 3;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short COMMENT_NODE = 8;
    public static final String READY_STATE_UNINITIALIZED = "uninitialized";
    public static final String READY_STATE_LOADING = "loading";
    public static final String READY_STATE_LOADED = "loaded";
    public static final String READY_STATE_INTERACTIVE = "interactive";
    public static final String READY_STATE_COMPLETE = "complete";
    private final Page page_;
    private DomNode parent_;
    private DomNode previousSibling_;
    private DomNode nextSibling_;
    private DomNode firstChild_;
    private transient ScriptableObject scriptObject_;
    private String readyState_ = "loading";
    private PropertyChangeSupport propertyChangeSupport_;
    public static final String PROPERTY_ELEMENT = "element";
    private int startLineNumber_;
    private int startColumnNumber_;
    private int endLineNumber_;
    private int endColumnNumber_;
    private List domListeners_;
    private final transient Object domListeners_lock_ = new Object();

    protected DomNode() {
        this(null);
    }

    protected DomNode(Page page) {
        this.page_ = page;
        this.startLineNumber_ = 0;
        this.startColumnNumber_ = 0;
        this.endLineNumber_ = 0;
        this.endColumnNumber_ = 0;
    }

    void setStartLocation(int startLineNumber, int startColumnNumber) {
        this.startLineNumber_ = startLineNumber;
        this.startColumnNumber_ = startColumnNumber;
    }

    void setEndLocation(int endLineNumber, int endColumnNumber) {
        this.endLineNumber_ = endLineNumber;
        this.endColumnNumber_ = endColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber_;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber_;
    }

    public int getEndLineNumber() {
        return this.endLineNumber_;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber_;
    }

    public HtmlPage getPage() {
        return (HtmlPage)this.page_;
    }

    public Page getNativePage() {
        return this.page_;
    }

    public void setScriptObject(ScriptableObject scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    public DomNode getLastChild() {
        return this.getLastDomChild();
    }

    public DomNode getLastDomChild() {
        if (this.firstChild_ != null) {
            return this.firstChild_.previousSibling_;
        }
        return null;
    }

    public DomNode getParentNode() {
        return this.getParentDomNode();
    }

    public DomNode getParentDomNode() {
        return this.parent_;
    }

    protected void setParentNode(DomNode parent) {
        this.parent_ = parent;
    }

    public DomNode getPreviousSibling() {
        return this.getPreviousDomSibling();
    }

    public DomNode getPreviousDomSibling() {
        if (this.parent_ == null || this == this.parent_.firstChild_) {
            return null;
        }
        return this.previousSibling_;
    }

    public DomNode getNextSibling() {
        return this.getNextDomSibling();
    }

    public DomNode getNextDomSibling() {
        return this.nextSibling_;
    }

    public DomNode getFirstChild() {
        return this.getFirstDomChild();
    }

    public DomNode getFirstDomChild() {
        return this.firstChild_;
    }

    public boolean isAncestorOf(DomNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParentDomNode();
        }
        return false;
    }

    protected void setPreviousSibling(DomNode previous) {
        this.previousSibling_ = previous;
    }

    protected void setNextSibling(DomNode next) {
        this.nextSibling_ = next;
    }

    public abstract short getNodeType();

    public abstract String getNodeName();

    public String getNamespaceURI() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) {
    }

    public boolean hasAttributes() {
        return false;
    }

    protected boolean isRenderedVisible() {
        return false;
    }

    protected boolean isTrimmedText() {
        return true;
    }

    public String asText() {
        String text = this.getChildrenAsText();
        text = DomNode.reduceWhitespace(text);
        if (this.isTrimmedText()) {
            text = text.trim();
        }
        return text;
    }

    protected final String getChildrenAsText() {
        StringBuffer buffer = new StringBuffer();
        Iterator childIterator = this.getChildIterator();
        if (!childIterator.hasNext()) {
            return "";
        }
        boolean previousNodeWasText = false;
        StringBuffer textBuffer = new StringBuffer();
        while (childIterator.hasNext()) {
            DomNode node = (DomNode)childIterator.next();
            if (node instanceof DomText) {
                textBuffer.append(((DomText)node).getData());
                previousNodeWasText = true;
                continue;
            }
            if (previousNodeWasText) {
                buffer.append(DomNode.reduceWhitespace(textBuffer.toString()));
                textBuffer.setLength(0);
                previousNodeWasText = false;
            }
            if (node.isRenderedVisible()) {
                buffer.append(" ");
                buffer.append(node.asText());
                buffer.append(" ");
                continue;
            }
            if (node.getNodeName().equals("p")) {
                buffer.append(" ");
                buffer.append(node.asText());
                continue;
            }
            buffer.append(node.asText());
        }
        if (previousNodeWasText) {
            buffer.append(textBuffer.toString());
        }
        return buffer.toString();
    }

    protected static String reduceWhitespace(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        int length = text.length();
        boolean whitespace = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\u00a0') {
                buffer.append(' ');
                whitespace = false;
                continue;
            }
            if (whitespace) {
                if (Character.isWhitespace(ch)) continue;
                buffer.append(ch);
                whitespace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                whitespace = true;
                buffer.append(' ');
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public String asXml() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXml("", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.println(indent + this);
        this.printChildrenAsXml(indent, printWriter);
    }

    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        for (DomNode child = this.getFirstDomChild(); child != null; child = child.getNextDomSibling()) {
            child.printXml(indent + "  ", printWriter);
        }
    }

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String x) {
    }

    public DomNode cloneNode(boolean deep) {
        return this.cloneDomNode(deep);
    }

    public DomNode cloneDomNode(boolean deep) {
        DomNode newnode;
        try {
            newnode = (DomNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported for node [" + this + "]");
        }
        newnode.parent_ = null;
        newnode.nextSibling_ = null;
        newnode.previousSibling_ = null;
        newnode.firstChild_ = null;
        newnode.scriptObject_ = null;
        if (deep) {
            DomNode child = this.firstChild_;
            while (child != null) {
                newnode.appendDomChild(child.cloneDomNode(true));
                child = child.nextSibling_;
            }
        }
        return newnode;
    }

    public ScriptableObject getScriptObject() {
        if (this.scriptObject_ == null) {
            if (this == this.page_) {
                throw new IllegalStateException("No script object associated with the Page");
            }
            this.scriptObject_ = ((SimpleScriptable)((DomNode)((Object)this.page_)).getScriptObject()).makeScriptableFor(this);
        }
        return this.scriptObject_;
    }

    public DomNode appendChild(DomNode node) {
        return this.appendDomChild(node);
    }

    public DomNode appendDomChild(DomNode node) {
        if (node instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)node;
            Iterator iterator = fragment.getChildIterator();
            while (iterator.hasNext()) {
                DomNode child = (DomNode)iterator.next();
                this.appendDomChild(child);
            }
        } else {
            if (node != this) {
                node.basicRemove();
            }
            if (this.firstChild_ == null) {
                this.firstChild_ = node;
                this.firstChild_.previousSibling_ = node;
            } else {
                DomNode last = this.getLastDomChild();
                last.nextSibling_ = node;
                node.previousSibling_ = last;
                node.nextSibling_ = null;
                this.firstChild_.previousSibling_ = node;
            }
            node.parent_ = this;
            if (!(this instanceof DomDocumentFragment) && (this.page_ instanceof HtmlPage || this instanceof HtmlPage)) {
                this.getPage().notifyNodeAdded(node);
            }
            this.fireNodeAdded(this, node);
        }
        return node;
    }

    public void insertBefore(DomNode newNode) throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException();
        }
        if (newNode == this) {
            return;
        }
        newNode.basicRemove();
        if (this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = newNode;
        } else {
            this.previousSibling_.nextSibling_ = newNode;
        }
        newNode.previousSibling_ = this.previousSibling_;
        newNode.nextSibling_ = this;
        this.previousSibling_ = newNode;
        newNode.parent_ = this.parent_;
        this.getPage().notifyNodeAdded(newNode);
        this.fireNodeAdded(this, newNode);
    }

    public void remove() throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException();
        }
        DomNode exParent = this.parent_;
        this.basicRemove();
        if (this.getNativePage() instanceof HtmlPage) {
            this.getPage().notifyNodeRemoved(this);
        }
        this.fireNodeDeleted(exParent, this);
        exParent.fireNodeDeleted(exParent, this);
    }

    private void basicRemove() {
        if (this.parent_ != null && this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = this.nextSibling_;
        } else if (this.previousSibling_ != null && this.previousSibling_.nextSibling_ == this) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null && this.nextSibling_.previousSibling_ == this) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        if (this.parent_ != null && this == this.parent_.getLastDomChild()) {
            this.parent_.firstChild_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
        this.parent_ = null;
    }

    public void replace(DomNode newNode) throws IllegalStateException {
        if (newNode != this) {
            this.insertBefore(newNode);
            this.remove();
        }
    }

    protected void onAddedToPage() {
        if (this.firstChild_ != null) {
            Iterator i = this.getChildIterator();
            while (i.hasNext()) {
                DomNode child = (DomNode)i.next();
                child.onAddedToPage();
            }
        }
    }

    protected void onAllChildrenAddedToPage() {
    }

    public Iterator getChildIterator() {
        return new ChildIterator();
    }

    public Function getEventHandler(String eventName) {
        return null;
    }

    public void setEventHandler(String eventName, Function eventHandler) {
    }

    public void setEventHandler(String eventName, String jsSnippet) {
    }

    public void removeEventHandler(String eventName) {
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ == null) {
            this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        Assert.notNull("listener", listener);
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.removePropertyChangeListener(listener);
        }
    }

    protected final synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport_ != null) {
            this.propertyChangeSupport_.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Iterator getAllHtmlChildElements() {
        return new DescendantElementsIterator();
    }

    public String getReadyState() {
        return this.readyState_;
    }

    public void setReadyState(String state) {
        this.readyState_ = state;
    }

    public void removeAllChildren() {
        if (this.getFirstDomChild() == null) {
            return;
        }
        Iterator it = this.getChildIterator();
        while (it.hasNext()) {
            DomNode child = (DomNode)it.next();
            child.removeAllChildren();
            it.remove();
        }
    }

    public List getByXPath(String xpathExpr) throws JaxenException {
        if (xpathExpr == null) {
            throw new NullPointerException("Null is not a valid xpath expression");
        }
        Navigator navigator = HtmlUnitXPath.buildSubtreeNavigator(this);
        HtmlUnitXPath xpath = new HtmlUnitXPath(xpathExpr, navigator);
        return xpath.selectNodes(this);
    }

    public Object getFirstByXPath(String xpathExpr) throws JaxenException {
        List results = this.getByXPath(xpathExpr);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    protected void notifyIncorrectness(String message) {
        IncorrectnessListener incorrectnessListener = this.getPage().getWebClient().getIncorrectnessListener();
        incorrectnessListener.notify(message, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomChangeListener(DomChangeListener listener) {
        Assert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ == null) {
                this.domListeners_ = new ArrayList();
            }
            if (!this.domListeners_.contains(listener)) {
                this.domListeners_.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomChangeListener(DomChangeListener listener) {
        Assert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                this.domListeners_.remove(listener);
            }
        }
    }

    protected void fireNodeAdded(DomNode parentNode, DomNode addedNode) {
        List listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, addedNode);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                DomChangeListener listener = (DomChangeListener)iterator.next();
                listener.nodeAdded(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeAdded(parentNode, addedNode);
        }
    }

    protected void fireNodeDeleted(DomNode parentNode, DomNode deletedNode) {
        List listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, deletedNode);
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                DomChangeListener listener = (DomChangeListener)iterator.next();
                listener.nodeDeleted(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeDeleted(parentNode, deletedNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List safeGetDomListeners() {
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                return new ArrayList(this.domListeners_);
            }
            return null;
        }
    }

    protected class DescendantElementsIterator
    implements Iterator {
        private HtmlElement nextElement_;

        protected DescendantElementsIterator() {
            this.nextElement_ = this.getFirstChildElement(DomNode.this);
        }

        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public HtmlElement nextElement() {
            HtmlElement result = this.nextElement_;
            this.setNextElement();
            return result;
        }

        private void setNextElement() {
            HtmlElement next = this.getFirstChildElement(this.nextElement_);
            if (next == null) {
                next = this.getNextDomSibling(this.nextElement_);
            }
            if (next == null) {
                next = this.getNextElementUpwards(this.nextElement_);
            }
            this.nextElement_ = next;
        }

        private HtmlElement getNextElementUpwards(DomNode startingNode) {
            DomNode next;
            if (startingNode == DomNode.this) {
                return null;
            }
            DomNode parent = startingNode.getParentDomNode();
            if (parent == DomNode.this) {
                return null;
            }
            for (next = parent.getNextDomSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextDomSibling()) {
            }
            if (next == null) {
                return this.getNextElementUpwards(parent);
            }
            return (HtmlElement)next;
        }

        private HtmlElement getFirstChildElement(DomNode parent) {
            DomNode node;
            if (parent instanceof HtmlNoScript && DomNode.this.getPage().getWebClient().isJavaScriptEnabled()) {
                return null;
            }
            for (node = parent.getFirstDomChild(); node != null && !(node instanceof HtmlElement); node = node.getNextDomSibling()) {
            }
            return (HtmlElement)node;
        }

        private HtmlElement getNextDomSibling(HtmlElement element) {
            DomNode node;
            for (node = element.getNextDomSibling(); node != null && !(node instanceof HtmlElement); node = node.getNextDomSibling()) {
            }
            return (HtmlElement)node;
        }
    }

    protected class ChildIterator
    implements Iterator {
        private DomNode nextNode_;
        private DomNode currentNode_;

        protected ChildIterator() {
            this.nextNode_ = DomNode.this.firstChild_;
            this.currentNode_ = null;
        }

        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        public Object next() {
            if (this.nextNode_ != null) {
                this.currentNode_ = this.nextNode_;
                this.nextNode_ = this.nextNode_.nextSibling_;
                return this.currentNode_;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException();
            }
            this.currentNode_.remove();
        }
    }
}

