/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.io.IOException;
import java.util.List;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class HTMLFormElement
extends HTMLElement {
    private static final long serialVersionUID = -1860993922147246513L;
    private HTMLCollection elements_;

    public final void jsConstructor() {
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptObject(this);
    }

    public String jsxGet_name() {
        return this.getHtmlForm().getNameAttribute();
    }

    public void jsxSet_name(String name) {
        Assert.notNull("name", name);
        this.getHtmlForm().setNameAttribute(name);
    }

    public HTMLCollection jsxGet_elements() {
        if (this.elements_ == null) {
            HtmlForm htmlForm = this.getHtmlForm();
            this.elements_ = new HTMLCollection(this);
            try {
                HtmlUnitXPath xpath = new HtmlUnitXPath("//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]", HtmlUnitXPath.buildSubtreeNavigator(htmlForm));
                this.elements_.init(htmlForm, (XPath)xpath);
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection form.elements: " + e.getMessage()));
            }
        }
        return this.elements_;
    }

    public int jsxGet_length() {
        int all = this.jsxGet_elements().jsxGet_length();
        int images = this.getHtmlForm().getHtmlElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    public String jsxGet_action() {
        return this.getHtmlForm().getActionAttribute();
    }

    public void jsxSet_action(String action) {
        Assert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    public String jsxGet_method() {
        return this.getHtmlForm().getMethodAttribute();
    }

    public void jsxSet_method(String method) {
        Assert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    public String jsxGet_target() {
        return this.getHtmlForm().getTargetAttribute();
    }

    public Object jsxGet_onsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    public void jsxSet_onsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    public void jsxSet_target(String target) {
        Assert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    public String jsxGet_encoding() {
        return this.getHtmlForm().getEnctypeAttribute();
    }

    public void jsxSet_encoding(String encoding) {
        Assert.notNull("encoding", encoding);
        this.getHtmlForm().setEnctypeAttribute(encoding);
    }

    private HtmlForm getHtmlForm() {
        return (HtmlForm)this.getHtmlElementOrDie();
    }

    public void jsxFunction_submit() throws IOException {
        this.getHtmlForm().submit((SubmittableElement)null);
    }

    public void jsxFunction_reset() {
        this.getHtmlForm().reset();
    }

    protected Object getWithPreemption(String name) {
        HtmlForm form = this.getHtmlForm();
        HtmlPage page = form.getPage();
        if (page != null) {
            List elements = page.getHtmlElementsByIdAndOrName(name);
            if (elements.isEmpty()) {
                return NOT_FOUND;
            }
            if (elements.size() == 1) {
                HtmlElement element = (HtmlElement)elements.get(0);
                String tagName = element.getTagName();
                String type = element.getAttribute("type").toLowerCase();
                if ("input".equals(tagName) && !"image".equals(type) || "button".equals(tagName) || "select".equals(tagName) || "textarea".equals(tagName) || "img".equals(tagName)) {
                    if (form.isAncestorOf(element)) {
                        return this.getScriptableFor(element);
                    }
                } else {
                    return NOT_FOUND;
                }
            }
        }
        HTMLCollection collection = new HTMLCollection(this);
        try {
            HtmlUnitXPath xpath = new HtmlUnitXPath("//*[(@name = '" + name + "' or @id = '" + name + "')" + " and ((name() = 'input' and translate(@type, 'IMAGE', 'image') != 'image') or name() = 'button'" + " or name() = 'select' or name() = 'textarea')]", HtmlUnitXPath.buildSubtreeNavigator(form));
            collection.init(form, (XPath)xpath);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection: " + e.getMessage()));
        }
        int length = collection.jsxGet_length();
        if (length == 0) {
            collection = new HTMLCollection(this);
            try {
                HtmlUnitXPath xpath = new HtmlUnitXPath("//*[(@name = '" + name + "' or @id = '" + name + "')" + " and name() = 'img']", HtmlUnitXPath.buildSubtreeNavigator(form));
                collection.init(form, (XPath)xpath);
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection: " + e.getMessage()));
            }
        }
        Object result = collection;
        length = collection.jsxGet_length();
        if (length == 0) {
            result = NOT_FOUND;
        } else if (length == 1) {
            result = collection.get(0, (Scriptable)collection);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        return this.jsxGet_elements().get(index, (Scriptable)((HTMLFormElement)start).jsxGet_elements());
    }
}

