/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import java.io.Reader;
import java.io.StringReader;
import java.util.WeakHashMap;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.css.sac.InputSource;

public class StyleSheetList
extends SimpleScriptable {
    private static final long serialVersionUID = -8607630805490604483L;
    private HTMLCollection nodes_;
    private WeakHashMap sheets_ = new WeakHashMap();

    public StyleSheetList() {
    }

    public StyleSheetList(Document document) {
        this.setParentScope((Scriptable)document);
        this.setPrototype(this.getPrototype(((Object)((Object)this)).getClass()));
        try {
            this.nodes_ = new HTMLCollection(document);
            this.nodes_.init(document.getHtmlPage(), (XPath)new HtmlUnitXPath("//style | //link[lower-case(@rel)='stylesheet']"));
        }
        catch (JaxenException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int jsxGet_length() {
        return this.nodes_.jsxGet_length();
    }

    public Stylesheet jsxFunction_item(int index) {
        HTMLElement element = (HTMLElement)this.nodes_.jsxFunction_item(new Integer(index));
        DomNode node = element.getDomNodeOrDie();
        Stylesheet sheet = (Stylesheet)((Object)this.sheets_.get(node));
        if (sheet == null) {
            if (node instanceof HtmlStyle) {
                HtmlStyle style = (HtmlStyle)node;
                String s = style.getFirstDomChild().asText();
                sheet = new Stylesheet(new InputSource((Reader)new StringReader(s)));
            } else {
                HtmlLink link = (HtmlLink)node;
                try {
                    HtmlPage htmlPage = link.getPage();
                    WebRequestSettings webRequestSettings = new WebRequestSettings(htmlPage.getFullyQualifiedUrl(link.getHrefAttribute()));
                    String content = htmlPage.getWebClient().loadWebResponse(webRequestSettings).getContentAsString();
                    InputSource source = new InputSource((Reader)new StringReader(content));
                    sheet = new Stylesheet(source);
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError((String)("Exception: " + e));
                }
            }
            this.sheets_.put(node, sheet);
        }
        return sheet;
    }
}

