/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.xml.XmlAttr;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import java.util.Iterator;
import java.util.Map;

public class XMLSerializer
extends SimpleScriptable {
    private static final long serialVersionUID = -934136191731299896L;

    public void jsConstructor() {
    }

    public String jsxFunction_serializeToString(Node root) {
        StringBuffer buffer = new StringBuffer();
        boolean isIE = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE();
        this.toXml(1, root.getDomNodeOrDie(), buffer, isIE);
        if (isIE) {
            buffer.append('\r').append('\n');
        }
        return buffer.toString();
    }

    private void toXml(int indent, DomNode node, StringBuffer buffer, boolean isIE) {
        buffer.append('<').append(node.getNodeName());
        if (node instanceof XmlElement) {
            Map attributes = ((XmlElement)node).getAttributes();
            Iterator keys = attributes.keySet().iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                XmlAttr attrib = (XmlAttr)attributes.get(name);
                buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
            }
        }
        boolean startTagClosed = false;
        Iterator iterator = node.getChildIterator();
        block5: while (iterator.hasNext()) {
            if (!startTagClosed) {
                buffer.append('>');
                startTagClosed = true;
            }
            DomNode child = (DomNode)iterator.next();
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer, isIE);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    if (isIE && value.trim().length() == 0) {
                        buffer.append('\r').append('\n');
                        DomNode sibling = child.getNextDomSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block5;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block5;
                    }
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            buffer.append('/').append('>');
        } else {
            buffer.append('<').append('/').append(node.getNodeName()).append('>');
        }
    }
}

