/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.xml.XmlAttr;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class XmlElement
extends DomNamespaceNode {
    private static final long serialVersionUID = -8119109851558707854L;
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    private Map namespaces_ = new HashMap();
    private Map attributes_;

    protected XmlElement(String namespaceURI, String qualifiedName, Page page, Map attributes) {
        super(namespaceURI, qualifiedName, page);
        this.attributes_ = attributes;
        Iterator values = attributes.values().iterator();
        while (values.hasNext()) {
            XmlAttr attr = (XmlAttr)values.next();
            attr.setParentNode(this);
        }
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public String getTagName() {
        if (this.getNamespaceURI() == null) {
            return this.getLocalName();
        }
        return this.getQualifiedName();
    }

    public final String getAttributeValue(String attributeName) {
        XmlAttr attr = (XmlAttr)this.attributes_.get(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    public Map getAttributes() {
        return this.attributes_;
    }

    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public final void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        this.setAttributeValue(namespaceURI, qualifiedName, attributeValue);
    }

    public final void setAttributeValue(String attributeName, String attributeValue) {
        this.setAttributeValue(null, attributeName, attributeValue);
    }

    public final void setAttributeValue(String namespaceURI, String qualifiedName, String attributeValue) {
        String value = attributeValue;
        if (this.attributes_ == Collections.EMPTY_MAP) {
            this.attributes_ = XmlElement.createAttributeMap(1);
        }
        XmlAttr newAttr = XmlElement.addAttributeToMap((XmlPage)this.getNativePage(), this.attributes_, namespaceURI, qualifiedName, value);
        if (namespaceURI != null) {
            this.namespaces_.put(namespaceURI, newAttr.getPrefix());
        }
        this.attributes_.put(newAttr.getName(), newAttr);
    }

    public final void removeAttribute(String attributeName) {
        this.attributes_.remove(attributeName.toLowerCase());
    }

    public final void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(this.getQualifiedName(namespaceURI, localName));
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        String qualifiedName = namespaceURI != null ? ((prefix = (String)this.namespaces_.get(namespaceURI)) != null ? prefix + ':' + localName : localName) : localName;
        return qualifiedName;
    }

    static Map createAttributeMap(int attributeCount) {
        return ListOrderedMap.decorate(new HashMap(attributeCount));
    }

    static XmlAttr addAttributeToMap(XmlPage page, Map attributeMap, String namespaceURI, String qualifiedName, String value) {
        XmlAttr newAttr = new XmlAttr(page, namespaceURI, qualifiedName, value);
        attributeMap.put(qualifiedName, newAttr);
        return newAttr;
    }
}

