/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlPage
extends SgmlPage {
    private static final long serialVersionUID = -1430136241030261308L;
    private Node node_;

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow) throws IOException {
        this(webResponse, enclosingWindow, true);
    }

    public XmlPage(Node node, WebWindow enclosingWindow) {
        super(null, enclosingWindow);
        this.node_ = node;
    }

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow, boolean ignoreSAXException) throws IOException {
        super(webResponse, enclosingWindow);
        try {
            this.node_ = webResponse == null || webResponse.getContentAsString().trim().length() == 0 ? DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().getDocumentElement() : XmlUtil.buildDocument(webResponse).getDocumentElement();
        }
        catch (SAXException e) {
            this.getLog().warn((Object)("Failed parsing xml document " + webResponse.getUrl() + ": " + e.getMessage()));
            if (!ignoreSAXException) {
                throw new IOException(e.getMessage());
            }
        }
        catch (ParserConfigurationException e) {
            this.getLog().warn((Object)("Failed parsing xml document " + webResponse.getUrl() + ": " + e.getMessage()));
        }
    }

    public void setScriptObject(ScriptableObject scriptObject) {
        super.setScriptObject(scriptObject);
        if (this.node_ != null) {
            XmlUtil.appendChild(this, this, this.node_);
        }
    }

    public void cleanUp() {
    }

    public String getContent() {
        return this.getWebResponse().getContentAsString();
    }

    public Document getXmlDocument() {
        if (this.node_ != null) {
            return this.node_.getOwnerDocument();
        }
        return null;
    }

    public XmlElement getDocumentXmlElement() {
        DomNode childNode;
        for (childNode = this.getFirstDomChild(); childNode != null && !(childNode instanceof XmlElement); childNode = childNode.getNextDomSibling()) {
        }
        return (XmlElement)childNode;
    }

    public XmlElement createXmlElement(String tagName) {
        return this.createXmlElementNS(null, tagName);
    }

    public XmlElement createXmlElementNS(String namespaceURI, String qualifiedName) {
        return new XmlElement(namespaceURI, qualifiedName, this, new HashMap());
    }
}

