/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomCData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlAttr;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtil {
    private static final ErrorHandler DISCARD_MESSAGES_HANDLER = new ErrorHandler(){

        public void error(SAXParseException exception) throws SAXException {
        }

        public void fatalError(SAXParseException exception) throws SAXException {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    };

    private XmlUtil() {
    }

    public static Document buildDocument(WebResponse webResponse) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        InputSource source = new InputSource(new StringReader(webResponse.getContentAsString()));
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DISCARD_MESSAGES_HANDLER);
        return builder.parse(source);
    }

    protected static Log getLog() {
        return LogFactory.getLog((Class)XmlUtil.class);
    }

    public static void appendChild(Page page, DomNode parent, Node child) {
        DomNode childXml = XmlUtil.createFrom(page, child);
        parent.appendDomChild(childXml);
        XmlUtil.copy(page, child, childXml);
    }

    private static DomNode createFrom(Page page, Node source) {
        if (source.getNodeType() == 3) {
            return new DomText(page, source.getNodeValue());
        }
        HashMap<String, XmlAttr> attributes = new HashMap<String, XmlAttr>();
        NamedNodeMap nodeAttributes = source.getAttributes();
        for (int i = 0; i < nodeAttributes.getLength(); ++i) {
            Node attribute = nodeAttributes.item(i);
            String qualifiedName = attribute.getPrefix() != null ? attribute.getPrefix() + ':' + attribute.getLocalName() : attribute.getLocalName();
            XmlAttr xmlAttribute = new XmlAttr(page, attribute.getNamespaceURI(), qualifiedName, attribute.getNodeValue());
            attributes.put(attribute.getNodeName(), xmlAttribute);
        }
        String localName = source.getLocalName();
        if (page instanceof HtmlPage) {
            localName = localName.toUpperCase();
        }
        String qualifiedName = source.getPrefix() == null ? localName : source.getPrefix() + ':' + localName;
        return new XmlElement(source.getNamespaceURI(), qualifiedName, page, attributes);
    }

    private static void copy(Page page, Node source, DomNode dest) {
        NodeList nodeChildren = source.getChildNodes();
        block6: for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    DomNode childXml = XmlUtil.createFrom(page, child);
                    dest.appendDomChild(childXml);
                    XmlUtil.copy(page, child, childXml);
                    continue block6;
                }
                case 3: {
                    DomText text = new DomText(page, child.getNodeValue());
                    dest.appendDomChild(text);
                    continue block6;
                }
                case 4: {
                    DomCData cdata = new DomCData(page, child.getNodeValue());
                    dest.appendDomChild(cdata);
                    continue block6;
                }
                case 8: {
                    DomComment comment = new DomComment(page, child.getNodeValue());
                    dest.appendDomChild(comment);
                    continue block6;
                }
                default: {
                    XmlUtil.getLog().warn((Object)("NodeType " + child.getNodeType() + " (" + child.getNodeName() + ") is not yet supported."));
                }
            }
        }
    }

    public static String lookupNamespaceURI(XmlElement element, String prefix) {
        DomNode parentNode;
        String uri = element.getAttributeValue("xmlns:" + prefix);
        if (uri == XmlElement.ATTRIBUTE_NOT_DEFINED && (parentNode = element.getParentDomNode()) instanceof XmlElement) {
            uri = XmlUtil.lookupNamespaceURI((XmlElement)parentNode, prefix);
        }
        return uri;
    }

    public static String lookupNamespaceURI(HtmlElement element, String prefix) {
        DomNode parentNode;
        String uri = element.getAttributeValue("xmlns:" + prefix);
        if (uri == HtmlElement.ATTRIBUTE_NOT_DEFINED && (parentNode = element.getParentDomNode()) instanceof HtmlElement) {
            uri = XmlUtil.lookupNamespaceURI((HtmlElement)parentNode, prefix);
        }
        return uri;
    }
}

