/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.ant;

import com.canoo.webtest.ant.TestStepSequence;
import com.canoo.webtest.ant.WebtestPropertyHelper;
import com.canoo.webtest.boundary.PackageBoundary;
import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.WebClientContext;
import com.canoo.webtest.interfaces.IPropertyHandler;
import com.canoo.webtest.reporting.IResultReporter;
import com.canoo.webtest.reporting.PlainTextReporter;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.StepExecutionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnsupportedElementException;

public class WebtestTask
extends Task
implements TaskContainer,
IPropertyHandler {
    private static final Logger LOG = Logger.getLogger((Class)WebtestTask.class);
    private String fName;
    private Configuration fConfig;
    private TestStepSequence fSteps;
    private boolean fImplicitSteps = true;
    public static final String REPORTER_CLASSNAME_PROPERTY = "webtest.resultreporterclass";
    public static final String DEFAULT_REPORTER_CLASSNAME = "com.canoo.webtest.reporting.XmlReporter";
    private final Map fDynamicProperties = new HashMap();
    private static final ThreadLocal CONTEXT_HOLDER = new ThreadLocal();
    private StepExecutionListener fResultBuilderListener;

    public static Context getThreadContext() {
        return (Context)CONTEXT_HOLDER.get();
    }

    public static void setThreadContext(Context context) {
        CONTEXT_HOLDER.set(context);
    }

    public void setDynamicProperty(String name, String value) {
        this.fDynamicProperties.put(name, value);
    }

    public String getDynamicProperty(String name) {
        return (String)this.fDynamicProperties.get(name);
    }

    public Map getDynamicProperties() {
        return this.fDynamicProperties;
    }

    public void addConfig(Configuration config) {
        if (this.fSteps != null) {
            String msg = config.getTaskName() + " invalid at this position! " + "It has to be the first node of \"" + this.getTaskName() + "\"!";
            throw new UnsupportedElementException(msg, config.getTaskName());
        }
        this.fConfig = config;
        this.fConfig.setPropertyHandler(this);
    }

    public void addTask(Task task) {
        LOG.debug((Object)("addTask: " + task.getTaskName() + " " + task));
        if (task instanceof Configuration) {
            this.addConfig((Configuration)task);
        } else if (task instanceof TestStepSequence) {
            this.addSteps((TestStepSequence)task);
        } else {
            if (!this.fImplicitSteps) {
                throw new UnsupportedElementException("No step allowed after </steps>!", task.getTaskName());
            }
            if (this.fSteps == null) {
                TestStepSequence implicitSteps = new TestStepSequence();
                implicitSteps.setDescription("Implicit <steps> task");
                implicitSteps.setTaskName("steps");
                implicitSteps.setProject(this.getProject());
                implicitSteps.setOwningTarget(task.getOwningTarget());
                implicitSteps.setLocation(task.getLocation());
                this.addSteps(implicitSteps);
                this.fImplicitSteps = true;
            }
            if (this.fImplicitSteps) {
                this.getStepSequence().getRuntimeConfigurableWrapper().addChild(task.getRuntimeConfigurableWrapper());
            }
            this.getStepSequence().addTask(task);
        }
    }

    public void addSteps(TestStepSequence steps) {
        if (this.getConfig() == null) {
            this.addConfig(this.createDefaultConfiguration());
            LOG.info((Object)"No configuration defined, using default configuration.");
        }
        if (this.fSteps != null) {
            String msg = this.getTaskName() + " doesn't support multiple nested \"" + steps.getTaskName() + "\" elements.";
            throw new UnsupportedElementException(msg, steps.getTaskName());
        }
        this.fSteps = steps;
        this.fImplicitSteps = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        String message;
        block8: {
            message = "webtest \"" + this.getName() + "\" (" + this.getLocation() + ")";
            LOG.info((Object)("Starting " + message));
            String webtestVersion = PackageBoundary.versionMessage();
            LOG.info((Object)webtestVersion);
            this.getProject().setProperty("webtest.version", webtestVersion);
            this.assertParametersNotNull();
            Context context = new Context(this);
            CONTEXT_HOLDER.set(context);
            LOG.debug((Object)"Executing configuration task");
            this.getConfig().setContext(context);
            this.getConfig().perform();
            PropertyHelper originalPropertyHelper = PropertyHelper.getPropertyHelper((Project)this.getProject());
            WebtestPropertyHelper.configureWebtestPropertyHelper(this.getProject());
            this.fResultBuilderListener = new StepExecutionListener(context);
            this.getProject().addBuildListener((BuildListener)this.fResultBuilderListener);
            try {
                try {
                    this.fSteps.perform();
                }
                catch (BuildException e) {
                    Object var7_6 = null;
                    this.getProject().removeBuildListener((BuildListener)this.fResultBuilderListener);
                    WebtestPropertyHelper.definePropertyHelper(this.getProject(), originalPropertyHelper);
                    Iterator iter = context.getWebClientContexts().values().iterator();
                    while (iter.hasNext()) {
                        WebClientContext webClientContext = (WebClientContext)iter.next();
                        webClientContext.destroy();
                    }
                    break block8;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.getProject().removeBuildListener((BuildListener)this.fResultBuilderListener);
                WebtestPropertyHelper.definePropertyHelper(this.getProject(), originalPropertyHelper);
                Iterator iter = context.getWebClientContexts().values().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        throw throwable;
                    }
                    WebClientContext webClientContext = (WebClientContext)iter.next();
                    webClientContext.destroy();
                }
            }
            this.getProject().removeBuildListener((BuildListener)this.fResultBuilderListener);
            WebtestPropertyHelper.definePropertyHelper(this.getProject(), originalPropertyHelper);
            Iterator iter = context.getWebClientContexts().values().iterator();
            while (iter.hasNext()) {
                WebClientContext webClientContext = (WebClientContext)iter.next();
                webClientContext.destroy();
            }
        }
        LOG.info((Object)("Finished executing " + message));
        this.writeTestReportIfNeeded(this.fResultBuilderListener.getRootResult());
        this.stopBuildIfNeeded(this.fResultBuilderListener.getRootResult(), this.fConfig);
    }

    protected StepExecutionListener getResultBuilderListener() {
        return this.fResultBuilderListener;
    }

    protected Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration(this);
        LOG.debug((Object)("Default configuration created: host=" + configuration.getHost() + ", port=" + configuration.getPort() + ", protocol=" + configuration.getProtocol()));
        return configuration;
    }

    protected void stopBuildIfNeeded(RootStepResult webTestResult, Configuration config) {
        LOG.debug((Object)"Looking if it is needed to stop the build");
        if (webTestResult.isError() && config.isHaltOnError() || webTestResult.isFailure() && config.isHaltOnFailure()) {
            LOG.debug((Object)("Exception: " + webTestResult.getException().getClass().getName()));
            LOG.debug((Object)"Throwing BuildException");
            if (webTestResult.getException() instanceof BuildException) {
                throw (BuildException)webTestResult.getException();
            }
            String str = PlainTextReporter.getBuildFailMessage(webTestResult);
            LOG.debug((Object)("str: " + str));
            throw new BuildException(webTestResult.getException());
        }
        if (webTestResult.isError() && !StringUtils.isEmpty((String)config.getErrorProperty())) {
            LOG.debug((Object)("Set error property \"" + config.getErrorProperty() + "\" to true"));
            this.getProject().setProperty(config.getErrorProperty(), "true");
        }
        if (webTestResult.isFailure() && !StringUtils.isEmpty((String)config.getFailureProperty())) {
            LOG.debug((Object)("Set failure property \"" + config.getFailureProperty() + "\" to true"));
            this.getProject().setProperty(config.getFailureProperty(), "true");
        }
    }

    public String getProperty(String propertyName) {
        return this.getProject().getProperty(propertyName);
    }

    private void assertParametersNotNull() throws BuildException {
        this.assertAttributeNotNull(this.fName, "name");
        this.assertNestedElementNotNull(this.fSteps, "steps");
    }

    private void assertAttributeNotNull(Object parameter, String parameterName) {
        String[] msg = new String[]{"attribute ", "\n", parameterName, "\n"};
        this.assertNotNull(parameter, msg);
    }

    private void assertNestedElementNotNull(Object parameter, String parameterName) {
        String[] msg = new String[]{"nested element ", "<", parameterName, ">"};
        this.assertNotNull(parameter, msg);
    }

    protected void assertNotNull(Object parameter, String[] msg) {
        if (parameter == null) {
            throw new BuildException("Required " + msg[0] + msg[1] + msg[2] + msg[3] + " is not set!");
        }
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    protected void writeTestReportIfNeeded(RootStepResult result) {
        if (!this.fConfig.isSummary()) {
            LOG.info((Object)"No report to write according to config");
            return;
        }
        String reporterClass = this.getProject().getProperty(REPORTER_CLASSNAME_PROPERTY);
        if (reporterClass == null) {
            reporterClass = DEFAULT_REPORTER_CLASSNAME;
        }
        LOG.debug((Object)("Writing test report using Report class: " + reporterClass));
        this.callSelectedReporter(reporterClass, result);
        LOG.debug((Object)"Report written");
    }

    protected void callSelectedReporter(String reporterClass, RootStepResult result) {
        try {
            IResultReporter reporter = (IResultReporter)Class.forName(reporterClass).newInstance();
            this.report(reporter, result);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught while writing test report", (Throwable)e);
        }
    }

    protected void report(IResultReporter reporter, RootStepResult result) {
        try {
            reporter.generateReport(result);
            LOG.info((Object)"Test report successfully created.");
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught while writing test report", (Throwable)e);
        }
    }

    public Configuration getConfig() {
        return this.fConfig;
    }

    protected void setConfig(Configuration config) {
        this.fConfig = config;
    }

    public TestStepSequence getStepSequence() {
        return this.fSteps;
    }
}

