/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import com.canoo.webtest.extension.applet.AbstractAppletTag;
import com.canoo.webtest.extension.applet.runner.Context;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import org.apache.log4j.Logger;
import org.netbeans.jemmy.JemmyException;

public class AppletRunnerBoundary {
    private static final Logger LOG = Logger.getLogger((Class)AppletRunnerBoundary.class);

    public static Object assertObjectHasCorrectClass(Class expectedClass, Object object, String msg) throws Exception {
        if (expectedClass.isInstance(object)) {
            return object;
        }
        String error = "Expected class " + expectedClass + " but found " + object.getClass().getName();
        LOG.error((Object)(msg + error));
        throw new Exception(msg + error);
    }

    public static URLClassLoader tryCreateUrlClassLoader(AbstractAppletTag appletTag, ClassLoader classLoader) throws Exception {
        try {
            return new URLClassLoader(appletTag.getArchiveURL(), classLoader);
        }
        catch (MalformedURLException e) {
            String msg = "Can't build classpath url for " + appletTag.getCode();
            LOG.error((Object)msg, (Throwable)e);
            throw new Exception(msg + " " + e.getMessage());
        }
    }

    public static void storeJemmyExceptionIfNeeded(JemmyException jemmyException, Context appletContext) {
        if (jemmyException != null) {
            appletContext.getAppletPluginResults().setJemmyException(jemmyException);
            LOG.error((Object)jemmyException.getMessage(), (Throwable)jemmyException);
        }
    }

    public void processClassNotFound(int classNotFoundErrorCode) {
        System.exit(classNotFoundErrorCode);
    }

    public void processIoException(int ioErrorCode) {
        System.exit(ioErrorCode);
    }
}

